<?php

namespace EnumType;

/**
 * This class stands for status EnumType
 * @subpackage Enumerations
 */
class Status
{
    /**
     * Constant for value 'NEW'
     * @return string 'NEW'
     */
    const VALUE_NEW = 'NEW';
    /**
     * Constant for value 'QUALIFIED'
     * @return string 'QUALIFIED'
     */
    const VALUE_QUALIFIED = 'QUALIFIED';
    /**
     * Constant for value 'PRE_SCHEDULED'
     * @return string 'PRE_SCHEDULED'
     */
    const VALUE_PRE_SCHEDULED = 'PRE_SCHEDULED';
    /**
     * Constant for value 'SCHEDULED'
     * @return string 'SCHEDULED'
     */
    const VALUE_SCHEDULED = 'SCHEDULED';
    /**
     * Constant for value 'IN_PROGRESS'
     * @return string 'IN_PROGRESS'
     */
    const VALUE_IN_PROGRESS = 'IN_PROGRESS';
    /**
     * Constant for value 'COMPLETED'
     * @return string 'COMPLETED'
     */
    const VALUE_COMPLETED = 'COMPLETED';
    /**
     * Constant for value 'VALIDATED'
     * @return string 'VALIDATED'
     */
    const VALUE_VALIDATED = 'VALIDATED';
    /**
     * Constant for value 'CANCELLED'
     * @return string 'CANCELLED'
     */
    const VALUE_CANCELLED = 'CANCELLED';
    /**
     * Constant for value 'UNDEFINED'
     * @return string 'UNDEFINED'
     */
    const VALUE_UNDEFINED = 'UNDEFINED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NEW
     * @uses self::VALUE_QUALIFIED
     * @uses self::VALUE_PRE_SCHEDULED
     * @uses self::VALUE_SCHEDULED
     * @uses self::VALUE_IN_PROGRESS
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_VALIDATED
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_UNDEFINED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEW,
            self::VALUE_QUALIFIED,
            self::VALUE_PRE_SCHEDULED,
            self::VALUE_SCHEDULED,
            self::VALUE_IN_PROGRESS,
            self::VALUE_COMPLETED,
            self::VALUE_VALIDATED,
            self::VALUE_CANCELLED,
            self::VALUE_UNDEFINED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
