<?php

namespace EnumType;

/**
 * This class stands for source EnumType
 * @subpackage Enumerations
 */
class Source
{
    /**
     * Constant for value 'CAMERA'
     * @return string 'CAMERA'
     */
    const VALUE_CAMERA = 'CAMERA';
    /**
     * Constant for value 'GALLERY'
     * @return string 'GALLERY'
     */
    const VALUE_GALLERY = 'GALLERY';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CAMERA
     * @uses self::VALUE_GALLERY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CAMERA,
            self::VALUE_GALLERY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
