<?php

namespace EnumType;

/**
 * This class stands for extendedReportSectionType EnumType
 * @subpackage Enumerations
 */
class ExtendedReportSectionType
{
    /**
     * Constant for value 'CLASSIC'
     * @return string 'CLASSIC'
     */
    const VALUE_CLASSIC = 'CLASSIC';
    /**
     * Constant for value 'TABLE'
     * @return string 'TABLE'
     */
    const VALUE_TABLE = 'TABLE';
    /**
     * Constant for value 'TABLE_HEADER'
     * @return string 'TABLE_HEADER'
     */
    const VALUE_TABLE_HEADER = 'TABLE_HEADER';
    /**
     * Constant for value 'BILLING'
     * @return string 'BILLING'
     */
    const VALUE_BILLING = 'BILLING';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CLASSIC
     * @uses self::VALUE_TABLE
     * @uses self::VALUE_TABLE_HEADER
     * @uses self::VALUE_BILLING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLASSIC,
            self::VALUE_TABLE,
            self::VALUE_TABLE_HEADER,
            self::VALUE_BILLING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
