<?php

namespace EnumType;

/**
 * This class stands for clickableOn EnumType
 * @subpackage Enumerations
 */
class ClickableOn
{
    /**
     * Constant for value 'BUSINESS_EVENT_COMPLETION'
     * @return string 'BUSINESS_EVENT_COMPLETION'
     */
    const VALUE_BUSINESS_EVENT_COMPLETION = 'BUSINESS_EVENT_COMPLETION';
    /**
     * Constant for value 'ALWAYS'
     * @return string 'ALWAYS'
     */
    const VALUE_ALWAYS = 'ALWAYS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BUSINESS_EVENT_COMPLETION
     * @uses self::VALUE_ALWAYS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BUSINESS_EVENT_COMPLETION,
            self::VALUE_ALWAYS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
