<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WsInflowItemType StructType
 * @subpackage Structs
 */
class WsInflowItemType extends AbstractStructBase
{
    /**
     * The ItemSKU
     * @var string
     */
    public $ItemSKU;
    /**
     * The ItemCodes
     * @var \StructType\ItemCodes
     */
    public $ItemCodes;
    /**
     * Constructor method for WsInflowItemType
     * @uses WsInflowItemType::setItemSKU()
     * @uses WsInflowItemType::setItemCodes()
     * @param string $itemSKU
     * @param \StructType\ItemCodes $itemCodes
     */
    public function __construct($itemSKU = null, \StructType\ItemCodes $itemCodes = null)
    {
        $this
            ->setItemSKU($itemSKU)
            ->setItemCodes($itemCodes);
    }
    /**
     * Get ItemSKU value
     * @return string|null
     */
    public function getItemSKU()
    {
        return $this->ItemSKU;
    }
    /**
     * Set ItemSKU value
     * @param string $itemSKU
     * @return \StructType\WsInflowItemType
     */
    public function setItemSKU($itemSKU = null)
    {
        // validation for constraint: string
        if (!is_null($itemSKU) && !is_string($itemSKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemSKU, true), gettype($itemSKU)), __LINE__);
        }
        $this->ItemSKU = $itemSKU;
        return $this;
    }
    /**
     * Get ItemCodes value
     * @return \StructType\ItemCodes|null
     */
    public function getItemCodes()
    {
        return $this->ItemCodes;
    }
    /**
     * Set ItemCodes value
     * @param \StructType\ItemCodes $itemCodes
     * @return \StructType\WsInflowItemType
     */
    public function setItemCodes(\StructType\ItemCodes $itemCodes = null)
    {
        $this->ItemCodes = $itemCodes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WsInflowItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
