<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorInvoiceItem StructType
 * @subpackage Structs
 */
class VendorInvoiceItem extends AbstractStructBase
{
    /**
     * The ItemSkuCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ItemSkuCode;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The UnitPrice
     * @var float
     */
    public $UnitPrice;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Discount;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The TaxPercentage
     * @var float
     */
    public $TaxPercentage;
    /**
     * The AdditionalTaxPercentage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AdditionalTaxPercentage;
    /**
     * Constructor method for VendorInvoiceItem
     * @uses VendorInvoiceItem::setItemSkuCode()
     * @uses VendorInvoiceItem::setDescription()
     * @uses VendorInvoiceItem::setUnitPrice()
     * @uses VendorInvoiceItem::setDiscount()
     * @uses VendorInvoiceItem::setQuantity()
     * @uses VendorInvoiceItem::setTaxPercentage()
     * @uses VendorInvoiceItem::setAdditionalTaxPercentage()
     * @param string $itemSkuCode
     * @param string $description
     * @param float $unitPrice
     * @param float $discount
     * @param int $quantity
     * @param float $taxPercentage
     * @param float $additionalTaxPercentage
     */
    public function __construct($itemSkuCode = null, $description = null, $unitPrice = null, $discount = null, $quantity = null, $taxPercentage = null, $additionalTaxPercentage = null)
    {
        $this
            ->setItemSkuCode($itemSkuCode)
            ->setDescription($description)
            ->setUnitPrice($unitPrice)
            ->setDiscount($discount)
            ->setQuantity($quantity)
            ->setTaxPercentage($taxPercentage)
            ->setAdditionalTaxPercentage($additionalTaxPercentage);
    }
    /**
     * Get ItemSkuCode value
     * @return string|null
     */
    public function getItemSkuCode()
    {
        return $this->ItemSkuCode;
    }
    /**
     * Set ItemSkuCode value
     * @param string $itemSkuCode
     * @return \StructType\VendorInvoiceItem
     */
    public function setItemSkuCode($itemSkuCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemSkuCode) && !is_string($itemSkuCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemSkuCode, true), gettype($itemSkuCode)), __LINE__);
        }
        $this->ItemSkuCode = $itemSkuCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\VendorInvoiceItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return float|null
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param float $unitPrice
     * @return \StructType\VendorInvoiceItem
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get Discount value
     * @return float|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param float $discount
     * @return \StructType\VendorInvoiceItem
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: float
        if (!is_null($discount) && !(is_float($discount) || is_numeric($discount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\VendorInvoiceItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get TaxPercentage value
     * @return float|null
     */
    public function getTaxPercentage()
    {
        return $this->TaxPercentage;
    }
    /**
     * Set TaxPercentage value
     * @param float $taxPercentage
     * @return \StructType\VendorInvoiceItem
     */
    public function setTaxPercentage($taxPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($taxPercentage) && !(is_float($taxPercentage) || is_numeric($taxPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxPercentage, true), gettype($taxPercentage)), __LINE__);
        }
        $this->TaxPercentage = $taxPercentage;
        return $this;
    }
    /**
     * Get AdditionalTaxPercentage value
     * @return float|null
     */
    public function getAdditionalTaxPercentage()
    {
        return $this->AdditionalTaxPercentage;
    }
    /**
     * Set AdditionalTaxPercentage value
     * @param float $additionalTaxPercentage
     * @return \StructType\VendorInvoiceItem
     */
    public function setAdditionalTaxPercentage($additionalTaxPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($additionalTaxPercentage) && !(is_float($additionalTaxPercentage) || is_numeric($additionalTaxPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($additionalTaxPercentage, true), gettype($additionalTaxPercentage)), __LINE__);
        }
        $this->AdditionalTaxPercentage = $additionalTaxPercentage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VendorInvoiceItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
