<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateTrackingStatusRequest StructType
 * @subpackage Structs
 */
class UpdateTrackingStatusRequest extends AbstractStructBase
{
    /**
     * The ShippingProviderCode
     * @var string
     */
    public $ShippingProviderCode;
    /**
     * The TrackingNumber
     * @var string
     */
    public $TrackingNumber;
    /**
     * The TrackingStatus
     * @var string
     */
    public $TrackingStatus;
    /**
     * The StatusDate
     * @var string
     */
    public $StatusDate;
    /**
     * Constructor method for UpdateTrackingStatusRequest
     * @uses UpdateTrackingStatusRequest::setShippingProviderCode()
     * @uses UpdateTrackingStatusRequest::setTrackingNumber()
     * @uses UpdateTrackingStatusRequest::setTrackingStatus()
     * @uses UpdateTrackingStatusRequest::setStatusDate()
     * @param string $shippingProviderCode
     * @param string $trackingNumber
     * @param string $trackingStatus
     * @param string $statusDate
     */
    public function __construct($shippingProviderCode = null, $trackingNumber = null, $trackingStatus = null, $statusDate = null)
    {
        $this
            ->setShippingProviderCode($shippingProviderCode)
            ->setTrackingNumber($trackingNumber)
            ->setTrackingStatus($trackingStatus)
            ->setStatusDate($statusDate);
    }
    /**
     * Get ShippingProviderCode value
     * @return string|null
     */
    public function getShippingProviderCode()
    {
        return $this->ShippingProviderCode;
    }
    /**
     * Set ShippingProviderCode value
     * @param string $shippingProviderCode
     * @return \StructType\UpdateTrackingStatusRequest
     */
    public function setShippingProviderCode($shippingProviderCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingProviderCode) && !is_string($shippingProviderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingProviderCode, true), gettype($shippingProviderCode)), __LINE__);
        }
        $this->ShippingProviderCode = $shippingProviderCode;
        return $this;
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \StructType\UpdateTrackingStatusRequest
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get TrackingStatus value
     * @return string|null
     */
    public function getTrackingStatus()
    {
        return $this->TrackingStatus;
    }
    /**
     * Set TrackingStatus value
     * @param string $trackingStatus
     * @return \StructType\UpdateTrackingStatusRequest
     */
    public function setTrackingStatus($trackingStatus = null)
    {
        // validation for constraint: string
        if (!is_null($trackingStatus) && !is_string($trackingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingStatus, true), gettype($trackingStatus)), __LINE__);
        }
        $this->TrackingStatus = $trackingStatus;
        return $this;
    }
    /**
     * Get StatusDate value
     * @return string|null
     */
    public function getStatusDate()
    {
        return $this->StatusDate;
    }
    /**
     * Set StatusDate value
     * @param string $statusDate
     * @return \StructType\UpdateTrackingStatusRequest
     */
    public function setStatusDate($statusDate = null)
    {
        // validation for constraint: string
        if (!is_null($statusDate) && !is_string($statusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDate, true), gettype($statusDate)), __LINE__);
        }
        $this->StatusDate = $statusDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateTrackingStatusRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
