<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxTypeConfiguration StructType
 * @subpackage Structs
 */
class TaxTypeConfiguration extends AbstractStructBase
{
    /**
     * The StateCode
     * @var string
     */
    public $StateCode;
    /**
     * The VAT
     * @var int
     */
    public $VAT;
    /**
     * The CST
     * @var int
     */
    public $CST;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The CstFormC
     * @var int
     */
    public $CstFormC;
    /**
     * Constructor method for TaxTypeConfiguration
     * @uses TaxTypeConfiguration::setStateCode()
     * @uses TaxTypeConfiguration::setVAT()
     * @uses TaxTypeConfiguration::setCST()
     * @uses TaxTypeConfiguration::setQuantity()
     * @uses TaxTypeConfiguration::setCstFormC()
     * @param string $stateCode
     * @param int $vAT
     * @param int $cST
     * @param int $quantity
     * @param int $cstFormC
     */
    public function __construct($stateCode = null, $vAT = null, $cST = null, $quantity = null, $cstFormC = null)
    {
        $this
            ->setStateCode($stateCode)
            ->setVAT($vAT)
            ->setCST($cST)
            ->setQuantity($quantity)
            ->setCstFormC($cstFormC);
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param string $stateCode
     * @return \StructType\TaxTypeConfiguration
     */
    public function setStateCode($stateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateCode) && !is_string($stateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateCode, true), gettype($stateCode)), __LINE__);
        }
        $this->StateCode = $stateCode;
        return $this;
    }
    /**
     * Get VAT value
     * @return int|null
     */
    public function getVAT()
    {
        return $this->VAT;
    }
    /**
     * Set VAT value
     * @param int $vAT
     * @return \StructType\TaxTypeConfiguration
     */
    public function setVAT($vAT = null)
    {
        // validation for constraint: int
        if (!is_null($vAT) && !(is_int($vAT) || ctype_digit($vAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vAT, true), gettype($vAT)), __LINE__);
        }
        $this->VAT = $vAT;
        return $this;
    }
    /**
     * Get CST value
     * @return int|null
     */
    public function getCST()
    {
        return $this->CST;
    }
    /**
     * Set CST value
     * @param int $cST
     * @return \StructType\TaxTypeConfiguration
     */
    public function setCST($cST = null)
    {
        // validation for constraint: int
        if (!is_null($cST) && !(is_int($cST) || ctype_digit($cST))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cST, true), gettype($cST)), __LINE__);
        }
        $this->CST = $cST;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\TaxTypeConfiguration
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get CstFormC value
     * @return int|null
     */
    public function getCstFormC()
    {
        return $this->CstFormC;
    }
    /**
     * Set CstFormC value
     * @param int $cstFormC
     * @return \StructType\TaxTypeConfiguration
     */
    public function setCstFormC($cstFormC = null)
    {
        // validation for constraint: int
        if (!is_null($cstFormC) && !(is_int($cstFormC) || ctype_digit($cstFormC))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cstFormC, true), gettype($cstFormC)), __LINE__);
        }
        $this->CstFormC = $cstFormC;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxTypeConfiguration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
