<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShippingProvider StructType
 * @subpackage Structs
 */
class ShippingProvider extends AbstractStructBase
{
    /**
     * The PacketNumber
     * @var int
     */
    public $PacketNumber;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The TrackingNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumber;
    /**
     * Constructor method for ShippingProvider
     * @uses ShippingProvider::setPacketNumber()
     * @uses ShippingProvider::setCode()
     * @uses ShippingProvider::setTrackingNumber()
     * @param int $packetNumber
     * @param string $code
     * @param string $trackingNumber
     */
    public function __construct($packetNumber = null, $code = null, $trackingNumber = null)
    {
        $this
            ->setPacketNumber($packetNumber)
            ->setCode($code)
            ->setTrackingNumber($trackingNumber);
    }
    /**
     * Get PacketNumber value
     * @return int|null
     */
    public function getPacketNumber()
    {
        return $this->PacketNumber;
    }
    /**
     * Set PacketNumber value
     * @param int $packetNumber
     * @return \StructType\ShippingProvider
     */
    public function setPacketNumber($packetNumber = null)
    {
        // validation for constraint: int
        if (!is_null($packetNumber) && !(is_int($packetNumber) || ctype_digit($packetNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packetNumber, true), gettype($packetNumber)), __LINE__);
        }
        $this->PacketNumber = $packetNumber;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\ShippingProvider
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \StructType\ShippingProvider
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShippingProvider
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
