<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShippingPackageCodes StructType
 * @subpackage Structs
 */
class ShippingPackageCodes extends AbstractStructBase
{
    /**
     * The PackageCode
     * @var string
     */
    public $PackageCode;
    /**
     * Constructor method for ShippingPackageCodes
     * @uses ShippingPackageCodes::setPackageCode()
     * @param string $packageCode
     */
    public function __construct($packageCode = null)
    {
        $this
            ->setPackageCode($packageCode);
    }
    /**
     * Get PackageCode value
     * @return string|null
     */
    public function getPackageCode()
    {
        return $this->PackageCode;
    }
    /**
     * Set PackageCode value
     * @param string $packageCode
     * @return \StructType\ShippingPackageCodes
     */
    public function setPackageCode($packageCode = null)
    {
        // validation for constraint: string
        if (!is_null($packageCode) && !is_string($packageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageCode, true), gettype($packageCode)), __LINE__);
        }
        $this->PackageCode = $packageCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShippingPackageCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
