<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickShippingPackageRequest StructType
 * @subpackage Structs
 */
class PickShippingPackageRequest extends AbstractStructBase
{
    /**
     * The SaleOrderCode
     * @var string
     */
    public $SaleOrderCode;
    /**
     * The ShippingPackageCode
     * @var string
     */
    public $ShippingPackageCode;
    /**
     * The ItemCodes
     * @var \StructType\ItemCodes
     */
    public $ItemCodes;
    /**
     * Constructor method for PickShippingPackageRequest
     * @uses PickShippingPackageRequest::setSaleOrderCode()
     * @uses PickShippingPackageRequest::setShippingPackageCode()
     * @uses PickShippingPackageRequest::setItemCodes()
     * @param string $saleOrderCode
     * @param string $shippingPackageCode
     * @param \StructType\ItemCodes $itemCodes
     */
    public function __construct($saleOrderCode = null, $shippingPackageCode = null, \StructType\ItemCodes $itemCodes = null)
    {
        $this
            ->setSaleOrderCode($saleOrderCode)
            ->setShippingPackageCode($shippingPackageCode)
            ->setItemCodes($itemCodes);
    }
    /**
     * Get SaleOrderCode value
     * @return string|null
     */
    public function getSaleOrderCode()
    {
        return $this->SaleOrderCode;
    }
    /**
     * Set SaleOrderCode value
     * @param string $saleOrderCode
     * @return \StructType\PickShippingPackageRequest
     */
    public function setSaleOrderCode($saleOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleOrderCode) && !is_string($saleOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOrderCode, true), gettype($saleOrderCode)), __LINE__);
        }
        $this->SaleOrderCode = $saleOrderCode;
        return $this;
    }
    /**
     * Get ShippingPackageCode value
     * @return string|null
     */
    public function getShippingPackageCode()
    {
        return $this->ShippingPackageCode;
    }
    /**
     * Set ShippingPackageCode value
     * @param string $shippingPackageCode
     * @return \StructType\PickShippingPackageRequest
     */
    public function setShippingPackageCode($shippingPackageCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingPackageCode) && !is_string($shippingPackageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingPackageCode, true), gettype($shippingPackageCode)), __LINE__);
        }
        $this->ShippingPackageCode = $shippingPackageCode;
        return $this;
    }
    /**
     * Get ItemCodes value
     * @return \StructType\ItemCodes|null
     */
    public function getItemCodes()
    {
        return $this->ItemCodes;
    }
    /**
     * Set ItemCodes value
     * @param \StructType\ItemCodes $itemCodes
     * @return \StructType\PickShippingPackageRequest
     */
    public function setItemCodes(\StructType\ItemCodes $itemCodes = null)
    {
        $this->ItemCodes = $itemCodes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PickShippingPackageRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
