<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManifestItems StructType
 * @subpackage Structs
 */
class ManifestItems extends AbstractStructBase
{
    /**
     * The ManifestItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ManifestItem[]
     */
    public $ManifestItem;
    /**
     * Constructor method for ManifestItems
     * @uses ManifestItems::setManifestItem()
     * @param \StructType\ManifestItem[] $manifestItem
     */
    public function __construct(array $manifestItem = array())
    {
        $this
            ->setManifestItem($manifestItem);
    }
    /**
     * Get ManifestItem value
     * @return \StructType\ManifestItem[]|null
     */
    public function getManifestItem()
    {
        return $this->ManifestItem;
    }
    /**
     * This method is responsible for validating the values passed to the setManifestItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setManifestItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateManifestItemForArrayConstraintsFromSetManifestItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $manifestItemsManifestItemItem) {
            // validation for constraint: itemType
            if (!$manifestItemsManifestItemItem instanceof \StructType\ManifestItem) {
                $invalidValues[] = is_object($manifestItemsManifestItemItem) ? get_class($manifestItemsManifestItemItem) : sprintf('%s(%s)', gettype($manifestItemsManifestItemItem), var_export($manifestItemsManifestItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ManifestItem property can only contain items of type \StructType\ManifestItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ManifestItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ManifestItem[] $manifestItem
     * @return \StructType\ManifestItems
     */
    public function setManifestItem(array $manifestItem = array())
    {
        // validation for constraint: array
        if ('' !== ($manifestItemArrayErrorMessage = self::validateManifestItemForArrayConstraintsFromSetManifestItem($manifestItem))) {
            throw new \InvalidArgumentException($manifestItemArrayErrorMessage, __LINE__);
        }
        $this->ManifestItem = $manifestItem;
        return $this;
    }
    /**
     * Add item to ManifestItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ManifestItem $item
     * @return \StructType\ManifestItems
     */
    public function addToManifestItem(\StructType\ManifestItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ManifestItem) {
            throw new \InvalidArgumentException(sprintf('The ManifestItem property can only contain items of type \StructType\ManifestItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ManifestItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ManifestItems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
