<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventorySnapshot StructType
 * @subpackage Structs
 */
class InventorySnapshot extends AbstractStructBase
{
    /**
     * The ItemSKU
     * @var string
     */
    public $ItemSKU;
    /**
     * The PendingInventoryAssessment
     * @var int
     */
    public $PendingInventoryAssessment;
    /**
     * The Inventory
     * @var int
     */
    public $Inventory;
    /**
     * The OpenSale
     * @var int
     */
    public $OpenSale;
    /**
     * The OpenPurchase
     * @var int
     */
    public $OpenPurchase;
    /**
     * The PutawayPending
     * @var int
     */
    public $PutawayPending;
    /**
     * The PendingStockTransfer
     * @var int
     */
    public $PendingStockTransfer;
    /**
     * The VendorInventory
     * @var int
     */
    public $VendorInventory;
    /**
     * The Facility
     * @var string
     */
    public $Facility;
    /**
     * The pendingStockTransfer
     * @var int
     */
    public $pendingStockTransfer;
    /**
     * Constructor method for InventorySnapshot
     * @uses InventorySnapshot::setItemSKU()
     * @uses InventorySnapshot::setPendingInventoryAssessment()
     * @uses InventorySnapshot::setInventory()
     * @uses InventorySnapshot::setOpenSale()
     * @uses InventorySnapshot::setOpenPurchase()
     * @uses InventorySnapshot::setPutawayPending()
     * @uses InventorySnapshot::setPendingStockTransfer()
     * @uses InventorySnapshot::setVendorInventory()
     * @uses InventorySnapshot::setFacility()
     * @uses InventorySnapshot::setPendingStockTransfer_1()
     * @param string $itemSKU
     * @param int $pendingInventoryAssessment
     * @param int $inventory
     * @param int $openSale
     * @param int $openPurchase
     * @param int $putawayPending
     * @param int $pendingStockTransfer
     * @param int $vendorInventory
     * @param string $facility
     * @param int $pendingStockTransfer
     */
    public function __construct($itemSKU = null, $pendingInventoryAssessment = null, $inventory = null, $openSale = null, $openPurchase = null, $putawayPending = null, $pendingStockTransfer = null, $vendorInventory = null, $facility = null, $pendingStockTransfer_1 = null)
    {
        $this
            ->setItemSKU($itemSKU)
            ->setPendingInventoryAssessment($pendingInventoryAssessment)
            ->setInventory($inventory)
            ->setOpenSale($openSale)
            ->setOpenPurchase($openPurchase)
            ->setPutawayPending($putawayPending)
            ->setPendingStockTransfer($pendingStockTransfer)
            ->setVendorInventory($vendorInventory)
            ->setFacility($facility)
            ->setPendingStockTransfer_1($pendingStockTransfer_1);
    }
    /**
     * Get ItemSKU value
     * @return string|null
     */
    public function getItemSKU()
    {
        return $this->ItemSKU;
    }
    /**
     * Set ItemSKU value
     * @param string $itemSKU
     * @return \StructType\InventorySnapshot
     */
    public function setItemSKU($itemSKU = null)
    {
        // validation for constraint: string
        if (!is_null($itemSKU) && !is_string($itemSKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemSKU, true), gettype($itemSKU)), __LINE__);
        }
        $this->ItemSKU = $itemSKU;
        return $this;
    }
    /**
     * Get PendingInventoryAssessment value
     * @return int|null
     */
    public function getPendingInventoryAssessment()
    {
        return $this->PendingInventoryAssessment;
    }
    /**
     * Set PendingInventoryAssessment value
     * @param int $pendingInventoryAssessment
     * @return \StructType\InventorySnapshot
     */
    public function setPendingInventoryAssessment($pendingInventoryAssessment = null)
    {
        // validation for constraint: int
        if (!is_null($pendingInventoryAssessment) && !(is_int($pendingInventoryAssessment) || ctype_digit($pendingInventoryAssessment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pendingInventoryAssessment, true), gettype($pendingInventoryAssessment)), __LINE__);
        }
        $this->PendingInventoryAssessment = $pendingInventoryAssessment;
        return $this;
    }
    /**
     * Get Inventory value
     * @return int|null
     */
    public function getInventory()
    {
        return $this->Inventory;
    }
    /**
     * Set Inventory value
     * @param int $inventory
     * @return \StructType\InventorySnapshot
     */
    public function setInventory($inventory = null)
    {
        // validation for constraint: int
        if (!is_null($inventory) && !(is_int($inventory) || ctype_digit($inventory))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inventory, true), gettype($inventory)), __LINE__);
        }
        $this->Inventory = $inventory;
        return $this;
    }
    /**
     * Get OpenSale value
     * @return int|null
     */
    public function getOpenSale()
    {
        return $this->OpenSale;
    }
    /**
     * Set OpenSale value
     * @param int $openSale
     * @return \StructType\InventorySnapshot
     */
    public function setOpenSale($openSale = null)
    {
        // validation for constraint: int
        if (!is_null($openSale) && !(is_int($openSale) || ctype_digit($openSale))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($openSale, true), gettype($openSale)), __LINE__);
        }
        $this->OpenSale = $openSale;
        return $this;
    }
    /**
     * Get OpenPurchase value
     * @return int|null
     */
    public function getOpenPurchase()
    {
        return $this->OpenPurchase;
    }
    /**
     * Set OpenPurchase value
     * @param int $openPurchase
     * @return \StructType\InventorySnapshot
     */
    public function setOpenPurchase($openPurchase = null)
    {
        // validation for constraint: int
        if (!is_null($openPurchase) && !(is_int($openPurchase) || ctype_digit($openPurchase))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($openPurchase, true), gettype($openPurchase)), __LINE__);
        }
        $this->OpenPurchase = $openPurchase;
        return $this;
    }
    /**
     * Get PutawayPending value
     * @return int|null
     */
    public function getPutawayPending()
    {
        return $this->PutawayPending;
    }
    /**
     * Set PutawayPending value
     * @param int $putawayPending
     * @return \StructType\InventorySnapshot
     */
    public function setPutawayPending($putawayPending = null)
    {
        // validation for constraint: int
        if (!is_null($putawayPending) && !(is_int($putawayPending) || ctype_digit($putawayPending))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($putawayPending, true), gettype($putawayPending)), __LINE__);
        }
        $this->PutawayPending = $putawayPending;
        return $this;
    }
    /**
     * Get PendingStockTransfer value
     * @return int|null
     */
    public function getPendingStockTransfer()
    {
        return $this->PendingStockTransfer;
    }
    /**
     * Set PendingStockTransfer value
     * @param int $pendingStockTransfer
     * @return \StructType\InventorySnapshot
     */
    public function setPendingStockTransfer($pendingStockTransfer = null)
    {
        // validation for constraint: int
        if (!is_null($pendingStockTransfer) && !(is_int($pendingStockTransfer) || ctype_digit($pendingStockTransfer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pendingStockTransfer, true), gettype($pendingStockTransfer)), __LINE__);
        }
        $this->PendingStockTransfer = $pendingStockTransfer;
        return $this;
    }
    /**
     * Get VendorInventory value
     * @return int|null
     */
    public function getVendorInventory()
    {
        return $this->VendorInventory;
    }
    /**
     * Set VendorInventory value
     * @param int $vendorInventory
     * @return \StructType\InventorySnapshot
     */
    public function setVendorInventory($vendorInventory = null)
    {
        // validation for constraint: int
        if (!is_null($vendorInventory) && !(is_int($vendorInventory) || ctype_digit($vendorInventory))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vendorInventory, true), gettype($vendorInventory)), __LINE__);
        }
        $this->VendorInventory = $vendorInventory;
        return $this;
    }
    /**
     * Get Facility value
     * @return string|null
     */
    public function getFacility()
    {
        return $this->Facility;
    }
    /**
     * Set Facility value
     * @param string $facility
     * @return \StructType\InventorySnapshot
     */
    public function setFacility($facility = null)
    {
        // validation for constraint: string
        if (!is_null($facility) && !is_string($facility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facility, true), gettype($facility)), __LINE__);
        }
        $this->Facility = $facility;
        return $this;
    }
    /**
     * Get PendingStockTransfer value
     * @return int|null
     */
    public function getPendingStockTransfer_1()
    {
        return $this->pendingStockTransfer;
    }
    /**
     * Set PendingStockTransfer value
     * @param int $pendingStockTransfer
     * @return \StructType\InventorySnapshot
     */
    public function setPendingStockTransfer_1($pendingStockTransfer_1 = null)
    {
        // validation for constraint: int
        if (!is_null($pendingStockTransfer_1) && !(is_int($pendingStockTransfer_1) || ctype_digit($pendingStockTransfer_1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pendingStockTransfer_1, true), gettype($pendingStockTransfer_1)), __LINE__);
        }
        $this->pendingStockTransfer = $pendingStockTransfer_1;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InventorySnapshot
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
