<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryAdjustmentRequest StructType
 * @subpackage Structs
 */
class InventoryAdjustmentRequest extends AbstractStructBase
{
    /**
     * The ItemSKU
     * @var string
     */
    public $ItemSKU;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The ShelfCode
     * @var string
     */
    public $ShelfCode;
    /**
     * The TransferToShelfCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransferToShelfCode;
    /**
     * The AdjustmentType
     * @var string
     */
    public $AdjustmentType;
    /**
     * The InventoryType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InventoryType;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Remarks;
    /**
     * Constructor method for InventoryAdjustmentRequest
     * @uses InventoryAdjustmentRequest::setItemSKU()
     * @uses InventoryAdjustmentRequest::setQuantity()
     * @uses InventoryAdjustmentRequest::setShelfCode()
     * @uses InventoryAdjustmentRequest::setTransferToShelfCode()
     * @uses InventoryAdjustmentRequest::setAdjustmentType()
     * @uses InventoryAdjustmentRequest::setInventoryType()
     * @uses InventoryAdjustmentRequest::setRemarks()
     * @param string $itemSKU
     * @param int $quantity
     * @param string $shelfCode
     * @param string $transferToShelfCode
     * @param string $adjustmentType
     * @param string $inventoryType
     * @param string $remarks
     */
    public function __construct($itemSKU = null, $quantity = null, $shelfCode = null, $transferToShelfCode = null, $adjustmentType = null, $inventoryType = null, $remarks = null)
    {
        $this
            ->setItemSKU($itemSKU)
            ->setQuantity($quantity)
            ->setShelfCode($shelfCode)
            ->setTransferToShelfCode($transferToShelfCode)
            ->setAdjustmentType($adjustmentType)
            ->setInventoryType($inventoryType)
            ->setRemarks($remarks);
    }
    /**
     * Get ItemSKU value
     * @return string|null
     */
    public function getItemSKU()
    {
        return $this->ItemSKU;
    }
    /**
     * Set ItemSKU value
     * @param string $itemSKU
     * @return \StructType\InventoryAdjustmentRequest
     */
    public function setItemSKU($itemSKU = null)
    {
        // validation for constraint: string
        if (!is_null($itemSKU) && !is_string($itemSKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemSKU, true), gettype($itemSKU)), __LINE__);
        }
        $this->ItemSKU = $itemSKU;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\InventoryAdjustmentRequest
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ShelfCode value
     * @return string|null
     */
    public function getShelfCode()
    {
        return $this->ShelfCode;
    }
    /**
     * Set ShelfCode value
     * @param string $shelfCode
     * @return \StructType\InventoryAdjustmentRequest
     */
    public function setShelfCode($shelfCode = null)
    {
        // validation for constraint: string
        if (!is_null($shelfCode) && !is_string($shelfCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shelfCode, true), gettype($shelfCode)), __LINE__);
        }
        $this->ShelfCode = $shelfCode;
        return $this;
    }
    /**
     * Get TransferToShelfCode value
     * @return string|null
     */
    public function getTransferToShelfCode()
    {
        return $this->TransferToShelfCode;
    }
    /**
     * Set TransferToShelfCode value
     * @param string $transferToShelfCode
     * @return \StructType\InventoryAdjustmentRequest
     */
    public function setTransferToShelfCode($transferToShelfCode = null)
    {
        // validation for constraint: string
        if (!is_null($transferToShelfCode) && !is_string($transferToShelfCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transferToShelfCode, true), gettype($transferToShelfCode)), __LINE__);
        }
        $this->TransferToShelfCode = $transferToShelfCode;
        return $this;
    }
    /**
     * Get AdjustmentType value
     * @return string|null
     */
    public function getAdjustmentType()
    {
        return $this->AdjustmentType;
    }
    /**
     * Set AdjustmentType value
     * @param string $adjustmentType
     * @return \StructType\InventoryAdjustmentRequest
     */
    public function setAdjustmentType($adjustmentType = null)
    {
        // validation for constraint: string
        if (!is_null($adjustmentType) && !is_string($adjustmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adjustmentType, true), gettype($adjustmentType)), __LINE__);
        }
        $this->AdjustmentType = $adjustmentType;
        return $this;
    }
    /**
     * Get InventoryType value
     * @return string|null
     */
    public function getInventoryType()
    {
        return $this->InventoryType;
    }
    /**
     * Set InventoryType value
     * @param string $inventoryType
     * @return \StructType\InventoryAdjustmentRequest
     */
    public function setInventoryType($inventoryType = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryType) && !is_string($inventoryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryType, true), gettype($inventoryType)), __LINE__);
        }
        $this->InventoryType = $inventoryType;
        return $this;
    }
    /**
     * Get Remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param string $remarks
     * @return \StructType\InventoryAdjustmentRequest
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarks, true), gettype($remarks)), __LINE__);
        }
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InventoryAdjustmentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
