<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditScriptConfigRequest StructType
 * @subpackage Structs
 */
class EditScriptConfigRequest extends AbstractStructBase
{
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Script
     * @var string
     */
    public $Script;
    /**
     * Constructor method for EditScriptConfigRequest
     * @uses EditScriptConfigRequest::setName()
     * @uses EditScriptConfigRequest::setScript()
     * @param string $name
     * @param string $script
     */
    public function __construct($name = null, $script = null)
    {
        $this
            ->setName($name)
            ->setScript($script);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\EditScriptConfigRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Script value
     * @return string|null
     */
    public function getScript()
    {
        return $this->Script;
    }
    /**
     * Set Script value
     * @param string $script
     * @return \StructType\EditScriptConfigRequest
     */
    public function setScript($script = null)
    {
        // validation for constraint: string
        if (!is_null($script) && !is_string($script)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($script, true), gettype($script)), __LINE__);
        }
        $this->Script = $script;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditScriptConfigRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
