<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateOrEditCategoryRequest StructType
 * @subpackage Structs
 */
class CreateOrEditCategoryRequest extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The TaxTypeCode
     * @var string
     */
    public $TaxTypeCode;
    /**
     * The ItemDetailFieldsText
     * @var string
     */
    public $ItemDetailFieldsText;
    /**
     * Constructor method for CreateOrEditCategoryRequest
     * @uses CreateOrEditCategoryRequest::setCode()
     * @uses CreateOrEditCategoryRequest::setName()
     * @uses CreateOrEditCategoryRequest::setTaxTypeCode()
     * @uses CreateOrEditCategoryRequest::setItemDetailFieldsText()
     * @param string $code
     * @param string $name
     * @param string $taxTypeCode
     * @param string $itemDetailFieldsText
     */
    public function __construct($code = null, $name = null, $taxTypeCode = null, $itemDetailFieldsText = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setTaxTypeCode($taxTypeCode)
            ->setItemDetailFieldsText($itemDetailFieldsText);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\CreateOrEditCategoryRequest
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CreateOrEditCategoryRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get TaxTypeCode value
     * @return string|null
     */
    public function getTaxTypeCode()
    {
        return $this->TaxTypeCode;
    }
    /**
     * Set TaxTypeCode value
     * @param string $taxTypeCode
     * @return \StructType\CreateOrEditCategoryRequest
     */
    public function setTaxTypeCode($taxTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxTypeCode) && !is_string($taxTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxTypeCode, true), gettype($taxTypeCode)), __LINE__);
        }
        $this->TaxTypeCode = $taxTypeCode;
        return $this;
    }
    /**
     * Get ItemDetailFieldsText value
     * @return string|null
     */
    public function getItemDetailFieldsText()
    {
        return $this->ItemDetailFieldsText;
    }
    /**
     * Set ItemDetailFieldsText value
     * @param string $itemDetailFieldsText
     * @return \StructType\CreateOrEditCategoryRequest
     */
    public function setItemDetailFieldsText($itemDetailFieldsText = null)
    {
        // validation for constraint: string
        if (!is_null($itemDetailFieldsText) && !is_string($itemDetailFieldsText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDetailFieldsText, true), gettype($itemDetailFieldsText)), __LINE__);
        }
        $this->ItemDetailFieldsText = $itemDetailFieldsText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateOrEditCategoryRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
