<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateInflowReceiptRequest StructType
 * @subpackage Structs
 */
class CreateInflowReceiptRequest extends AbstractStructBase
{
    /**
     * The InflowReceipt
     * @var \StructType\GRN
     */
    public $InflowReceipt;
    /**
     * The PurchaseOrderCode
     * @var string
     */
    public $PurchaseOrderCode;
    /**
     * Constructor method for CreateInflowReceiptRequest
     * @uses CreateInflowReceiptRequest::setInflowReceipt()
     * @uses CreateInflowReceiptRequest::setPurchaseOrderCode()
     * @param \StructType\GRN $inflowReceipt
     * @param string $purchaseOrderCode
     */
    public function __construct(\StructType\GRN $inflowReceipt = null, $purchaseOrderCode = null)
    {
        $this
            ->setInflowReceipt($inflowReceipt)
            ->setPurchaseOrderCode($purchaseOrderCode);
    }
    /**
     * Get InflowReceipt value
     * @return \StructType\GRN|null
     */
    public function getInflowReceipt()
    {
        return $this->InflowReceipt;
    }
    /**
     * Set InflowReceipt value
     * @param \StructType\GRN $inflowReceipt
     * @return \StructType\CreateInflowReceiptRequest
     */
    public function setInflowReceipt(\StructType\GRN $inflowReceipt = null)
    {
        $this->InflowReceipt = $inflowReceipt;
        return $this;
    }
    /**
     * Get PurchaseOrderCode value
     * @return string|null
     */
    public function getPurchaseOrderCode()
    {
        return $this->PurchaseOrderCode;
    }
    /**
     * Set PurchaseOrderCode value
     * @param string $purchaseOrderCode
     * @return \StructType\CreateInflowReceiptRequest
     */
    public function setPurchaseOrderCode($purchaseOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderCode) && !is_string($purchaseOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderCode, true), gettype($purchaseOrderCode)), __LINE__);
        }
        $this->PurchaseOrderCode = $purchaseOrderCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateInflowReceiptRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
