<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateApprovedPurchaseOrderRequest StructType
 * @subpackage Structs
 */
class CreateApprovedPurchaseOrderRequest extends AbstractStructBase
{
    /**
     * The PurchaseOrderCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PurchaseOrderCode;
    /**
     * The VendorCode
     * @var string
     */
    public $VendorCode;
    /**
     * The VendorAgreementName
     * @var string
     */
    public $VendorAgreementName;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExpiryDate;
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDate;
    /**
     * The PurchaseOrderItems
     * @var \StructType\PurchaseOrderItems
     */
    public $PurchaseOrderItems;
    /**
     * Constructor method for CreateApprovedPurchaseOrderRequest
     * @uses CreateApprovedPurchaseOrderRequest::setPurchaseOrderCode()
     * @uses CreateApprovedPurchaseOrderRequest::setVendorCode()
     * @uses CreateApprovedPurchaseOrderRequest::setVendorAgreementName()
     * @uses CreateApprovedPurchaseOrderRequest::setCurrencyCode()
     * @uses CreateApprovedPurchaseOrderRequest::setExpiryDate()
     * @uses CreateApprovedPurchaseOrderRequest::setDeliveryDate()
     * @uses CreateApprovedPurchaseOrderRequest::setPurchaseOrderItems()
     * @param string $purchaseOrderCode
     * @param string $vendorCode
     * @param string $vendorAgreementName
     * @param string $currencyCode
     * @param string $expiryDate
     * @param string $deliveryDate
     * @param \StructType\PurchaseOrderItems $purchaseOrderItems
     */
    public function __construct($purchaseOrderCode = null, $vendorCode = null, $vendorAgreementName = null, $currencyCode = null, $expiryDate = null, $deliveryDate = null, \StructType\PurchaseOrderItems $purchaseOrderItems = null)
    {
        $this
            ->setPurchaseOrderCode($purchaseOrderCode)
            ->setVendorCode($vendorCode)
            ->setVendorAgreementName($vendorAgreementName)
            ->setCurrencyCode($currencyCode)
            ->setExpiryDate($expiryDate)
            ->setDeliveryDate($deliveryDate)
            ->setPurchaseOrderItems($purchaseOrderItems);
    }
    /**
     * Get PurchaseOrderCode value
     * @return string|null
     */
    public function getPurchaseOrderCode()
    {
        return $this->PurchaseOrderCode;
    }
    /**
     * Set PurchaseOrderCode value
     * @param string $purchaseOrderCode
     * @return \StructType\CreateApprovedPurchaseOrderRequest
     */
    public function setPurchaseOrderCode($purchaseOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderCode) && !is_string($purchaseOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderCode, true), gettype($purchaseOrderCode)), __LINE__);
        }
        $this->PurchaseOrderCode = $purchaseOrderCode;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\CreateApprovedPurchaseOrderRequest
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCode, true), gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get VendorAgreementName value
     * @return string|null
     */
    public function getVendorAgreementName()
    {
        return $this->VendorAgreementName;
    }
    /**
     * Set VendorAgreementName value
     * @param string $vendorAgreementName
     * @return \StructType\CreateApprovedPurchaseOrderRequest
     */
    public function setVendorAgreementName($vendorAgreementName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorAgreementName) && !is_string($vendorAgreementName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorAgreementName, true), gettype($vendorAgreementName)), __LINE__);
        }
        $this->VendorAgreementName = $vendorAgreementName;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CreateApprovedPurchaseOrderRequest
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get ExpiryDate value
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->ExpiryDate;
    }
    /**
     * Set ExpiryDate value
     * @param string $expiryDate
     * @return \StructType\CreateApprovedPurchaseOrderRequest
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        $this->ExpiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \StructType\CreateApprovedPurchaseOrderRequest
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get PurchaseOrderItems value
     * @return \StructType\PurchaseOrderItems|null
     */
    public function getPurchaseOrderItems()
    {
        return $this->PurchaseOrderItems;
    }
    /**
     * Set PurchaseOrderItems value
     * @param \StructType\PurchaseOrderItems $purchaseOrderItems
     * @return \StructType\CreateApprovedPurchaseOrderRequest
     */
    public function setPurchaseOrderItems(\StructType\PurchaseOrderItems $purchaseOrderItems = null)
    {
        $this->PurchaseOrderItems = $purchaseOrderItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateApprovedPurchaseOrderRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
