<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BackOrderItems StructType
 * @subpackage Structs
 */
class BackOrderItems extends AbstractStructBase
{
    /**
     * The BackOrderItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\BackOrderItem[]
     */
    public $BackOrderItem;
    /**
     * Constructor method for BackOrderItems
     * @uses BackOrderItems::setBackOrderItem()
     * @param \StructType\BackOrderItem[] $backOrderItem
     */
    public function __construct(array $backOrderItem = array())
    {
        $this
            ->setBackOrderItem($backOrderItem);
    }
    /**
     * Get BackOrderItem value
     * @return \StructType\BackOrderItem[]|null
     */
    public function getBackOrderItem()
    {
        return $this->BackOrderItem;
    }
    /**
     * This method is responsible for validating the values passed to the setBackOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBackOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBackOrderItemForArrayConstraintsFromSetBackOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $backOrderItemsBackOrderItemItem) {
            // validation for constraint: itemType
            if (!$backOrderItemsBackOrderItemItem instanceof \StructType\BackOrderItem) {
                $invalidValues[] = is_object($backOrderItemsBackOrderItemItem) ? get_class($backOrderItemsBackOrderItemItem) : sprintf('%s(%s)', gettype($backOrderItemsBackOrderItemItem), var_export($backOrderItemsBackOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BackOrderItem property can only contain items of type \StructType\BackOrderItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BackOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\BackOrderItem[] $backOrderItem
     * @return \StructType\BackOrderItems
     */
    public function setBackOrderItem(array $backOrderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($backOrderItemArrayErrorMessage = self::validateBackOrderItemForArrayConstraintsFromSetBackOrderItem($backOrderItem))) {
            throw new \InvalidArgumentException($backOrderItemArrayErrorMessage, __LINE__);
        }
        $this->BackOrderItem = $backOrderItem;
        return $this;
    }
    /**
     * Add item to BackOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\BackOrderItem $item
     * @return \StructType\BackOrderItems
     */
    public function addToBackOrderItem(\StructType\BackOrderItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BackOrderItem) {
            throw new \InvalidArgumentException(sprintf('The BackOrderItem property can only contain items of type \StructType\BackOrderItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BackOrderItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BackOrderItems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
