<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutoCompletePutawayRequest StructType
 * @subpackage Structs
 */
class AutoCompletePutawayRequest extends AbstractStructBase
{
    /**
     * The PurchaseOrderCode
     * @var string
     */
    public $PurchaseOrderCode;
    /**
     * The InflowReceiptCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InflowReceiptCode;
    /**
     * The VendorInvoiceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VendorInvoiceNumber;
    /**
     * The VendorInvoiceDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VendorInvoiceDate;
    /**
     * The OnlyPrepareGRN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OnlyPrepareGRN;
    /**
     * The InflowItemTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InflowItemTypes
     */
    public $InflowItemTypes;
    /**
     * Constructor method for AutoCompletePutawayRequest
     * @uses AutoCompletePutawayRequest::setPurchaseOrderCode()
     * @uses AutoCompletePutawayRequest::setInflowReceiptCode()
     * @uses AutoCompletePutawayRequest::setVendorInvoiceNumber()
     * @uses AutoCompletePutawayRequest::setVendorInvoiceDate()
     * @uses AutoCompletePutawayRequest::setOnlyPrepareGRN()
     * @uses AutoCompletePutawayRequest::setInflowItemTypes()
     * @param string $purchaseOrderCode
     * @param string $inflowReceiptCode
     * @param string $vendorInvoiceNumber
     * @param string $vendorInvoiceDate
     * @param bool $onlyPrepareGRN
     * @param \StructType\InflowItemTypes $inflowItemTypes
     */
    public function __construct($purchaseOrderCode = null, $inflowReceiptCode = null, $vendorInvoiceNumber = null, $vendorInvoiceDate = null, $onlyPrepareGRN = null, \StructType\InflowItemTypes $inflowItemTypes = null)
    {
        $this
            ->setPurchaseOrderCode($purchaseOrderCode)
            ->setInflowReceiptCode($inflowReceiptCode)
            ->setVendorInvoiceNumber($vendorInvoiceNumber)
            ->setVendorInvoiceDate($vendorInvoiceDate)
            ->setOnlyPrepareGRN($onlyPrepareGRN)
            ->setInflowItemTypes($inflowItemTypes);
    }
    /**
     * Get PurchaseOrderCode value
     * @return string|null
     */
    public function getPurchaseOrderCode()
    {
        return $this->PurchaseOrderCode;
    }
    /**
     * Set PurchaseOrderCode value
     * @param string $purchaseOrderCode
     * @return \StructType\AutoCompletePutawayRequest
     */
    public function setPurchaseOrderCode($purchaseOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderCode) && !is_string($purchaseOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderCode, true), gettype($purchaseOrderCode)), __LINE__);
        }
        $this->PurchaseOrderCode = $purchaseOrderCode;
        return $this;
    }
    /**
     * Get InflowReceiptCode value
     * @return string|null
     */
    public function getInflowReceiptCode()
    {
        return $this->InflowReceiptCode;
    }
    /**
     * Set InflowReceiptCode value
     * @param string $inflowReceiptCode
     * @return \StructType\AutoCompletePutawayRequest
     */
    public function setInflowReceiptCode($inflowReceiptCode = null)
    {
        // validation for constraint: string
        if (!is_null($inflowReceiptCode) && !is_string($inflowReceiptCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inflowReceiptCode, true), gettype($inflowReceiptCode)), __LINE__);
        }
        $this->InflowReceiptCode = $inflowReceiptCode;
        return $this;
    }
    /**
     * Get VendorInvoiceNumber value
     * @return string|null
     */
    public function getVendorInvoiceNumber()
    {
        return $this->VendorInvoiceNumber;
    }
    /**
     * Set VendorInvoiceNumber value
     * @param string $vendorInvoiceNumber
     * @return \StructType\AutoCompletePutawayRequest
     */
    public function setVendorInvoiceNumber($vendorInvoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vendorInvoiceNumber) && !is_string($vendorInvoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorInvoiceNumber, true), gettype($vendorInvoiceNumber)), __LINE__);
        }
        $this->VendorInvoiceNumber = $vendorInvoiceNumber;
        return $this;
    }
    /**
     * Get VendorInvoiceDate value
     * @return string|null
     */
    public function getVendorInvoiceDate()
    {
        return $this->VendorInvoiceDate;
    }
    /**
     * Set VendorInvoiceDate value
     * @param string $vendorInvoiceDate
     * @return \StructType\AutoCompletePutawayRequest
     */
    public function setVendorInvoiceDate($vendorInvoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($vendorInvoiceDate) && !is_string($vendorInvoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorInvoiceDate, true), gettype($vendorInvoiceDate)), __LINE__);
        }
        $this->VendorInvoiceDate = $vendorInvoiceDate;
        return $this;
    }
    /**
     * Get OnlyPrepareGRN value
     * @return bool|null
     */
    public function getOnlyPrepareGRN()
    {
        return $this->OnlyPrepareGRN;
    }
    /**
     * Set OnlyPrepareGRN value
     * @param bool $onlyPrepareGRN
     * @return \StructType\AutoCompletePutawayRequest
     */
    public function setOnlyPrepareGRN($onlyPrepareGRN = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyPrepareGRN) && !is_bool($onlyPrepareGRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyPrepareGRN, true), gettype($onlyPrepareGRN)), __LINE__);
        }
        $this->OnlyPrepareGRN = $onlyPrepareGRN;
        return $this;
    }
    /**
     * Get InflowItemTypes value
     * @return \StructType\InflowItemTypes|null
     */
    public function getInflowItemTypes()
    {
        return $this->InflowItemTypes;
    }
    /**
     * Set InflowItemTypes value
     * @param \StructType\InflowItemTypes $inflowItemTypes
     * @return \StructType\AutoCompletePutawayRequest
     */
    public function setInflowItemTypes(\StructType\InflowItemTypes $inflowItemTypes = null)
    {
        $this->InflowItemTypes = $inflowItemTypes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AutoCompletePutawayRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
