<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddShipmentsToBatchRequest StructType
 * @subpackage Structs
 */
class AddShipmentsToBatchRequest extends AbstractStructBase
{
    /**
     * The ShipmentBatchCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentBatchCode;
    /**
     * The ShippingPackageCodes
     * @var \StructType\ShippingPackageCodes
     */
    public $ShippingPackageCodes;
    /**
     * Constructor method for AddShipmentsToBatchRequest
     * @uses AddShipmentsToBatchRequest::setShipmentBatchCode()
     * @uses AddShipmentsToBatchRequest::setShippingPackageCodes()
     * @param string $shipmentBatchCode
     * @param \StructType\ShippingPackageCodes $shippingPackageCodes
     */
    public function __construct($shipmentBatchCode = null, \StructType\ShippingPackageCodes $shippingPackageCodes = null)
    {
        $this
            ->setShipmentBatchCode($shipmentBatchCode)
            ->setShippingPackageCodes($shippingPackageCodes);
    }
    /**
     * Get ShipmentBatchCode value
     * @return string|null
     */
    public function getShipmentBatchCode()
    {
        return $this->ShipmentBatchCode;
    }
    /**
     * Set ShipmentBatchCode value
     * @param string $shipmentBatchCode
     * @return \StructType\AddShipmentsToBatchRequest
     */
    public function setShipmentBatchCode($shipmentBatchCode = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentBatchCode) && !is_string($shipmentBatchCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentBatchCode, true), gettype($shipmentBatchCode)), __LINE__);
        }
        $this->ShipmentBatchCode = $shipmentBatchCode;
        return $this;
    }
    /**
     * Get ShippingPackageCodes value
     * @return \StructType\ShippingPackageCodes|null
     */
    public function getShippingPackageCodes()
    {
        return $this->ShippingPackageCodes;
    }
    /**
     * Set ShippingPackageCodes value
     * @param \StructType\ShippingPackageCodes $shippingPackageCodes
     * @return \StructType\AddShipmentsToBatchRequest
     */
    public function setShippingPackageCodes(\StructType\ShippingPackageCodes $shippingPackageCodes = null)
    {
        $this->ShippingPackageCodes = $shippingPackageCodes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddShipmentsToBatchRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
