<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Modify ServiceType
 * @subpackage Services
 */
class Modify extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ModifyPacketSaleOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifyPacketSaleOrderRequest $modifyPacketSaleOrderRequest
     * @return \StructType\ModifyPacketSaleOrderResponse|bool
     */
    public function ModifyPacketSaleOrder(\StructType\ModifyPacketSaleOrderRequest $modifyPacketSaleOrderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifyPacketSaleOrder($modifyPacketSaleOrderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ModifyPacketSaleOrderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
