<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Hold ServiceType
 * @subpackage Services
 */
class Hold extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named HoldSaleOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HoldSaleOrderRequest $holdSaleOrderRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function HoldSaleOrder(\StructType\HoldSaleOrderRequest $holdSaleOrderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->HoldSaleOrder($holdSaleOrderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HoldSaleOrderItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HoldSaleOrderItemsRequest $holdSaleOrderItemsRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function HoldSaleOrderItems(\StructType\HoldSaleOrderItemsRequest $holdSaleOrderItemsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->HoldSaleOrderItems($holdSaleOrderItemsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ServiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
