<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Complete ServiceType
 * @subpackage Services
 */
class Complete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CompleteGatePass
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CompleteGatePassRequest $completeGatePassRequest
     * @return \StructType\CompleteGatePassResponse|bool
     */
    public function CompleteGatePass(\StructType\CompleteGatePassRequest $completeGatePassRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CompleteGatePass($completeGatePassRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CompleteGatePassResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
