<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SplitSaleOrderItem StructType
 * @subpackage Structs
 */
class SplitSaleOrderItem extends AbstractStructBase
{
    /**
     * The SaleOrderItemCode
     * @var string
     */
    public $SaleOrderItemCode;
    /**
     * The SplitPacketNumber
     * @var int
     */
    public $SplitPacketNumber;
    /**
     * Constructor method for SplitSaleOrderItem
     * @uses SplitSaleOrderItem::setSaleOrderItemCode()
     * @uses SplitSaleOrderItem::setSplitPacketNumber()
     * @param string $saleOrderItemCode
     * @param int $splitPacketNumber
     */
    public function __construct($saleOrderItemCode = null, $splitPacketNumber = null)
    {
        $this
            ->setSaleOrderItemCode($saleOrderItemCode)
            ->setSplitPacketNumber($splitPacketNumber);
    }
    /**
     * Get SaleOrderItemCode value
     * @return string|null
     */
    public function getSaleOrderItemCode()
    {
        return $this->SaleOrderItemCode;
    }
    /**
     * Set SaleOrderItemCode value
     * @param string $saleOrderItemCode
     * @return \StructType\SplitSaleOrderItem
     */
    public function setSaleOrderItemCode($saleOrderItemCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleOrderItemCode) && !is_string($saleOrderItemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOrderItemCode, true), gettype($saleOrderItemCode)), __LINE__);
        }
        $this->SaleOrderItemCode = $saleOrderItemCode;
        return $this;
    }
    /**
     * Get SplitPacketNumber value
     * @return int|null
     */
    public function getSplitPacketNumber()
    {
        return $this->SplitPacketNumber;
    }
    /**
     * Set SplitPacketNumber value
     * @param int $splitPacketNumber
     * @return \StructType\SplitSaleOrderItem
     */
    public function setSplitPacketNumber($splitPacketNumber = null)
    {
        // validation for constraint: int
        if (!is_null($splitPacketNumber) && !(is_int($splitPacketNumber) || ctype_digit($splitPacketNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($splitPacketNumber, true), gettype($splitPacketNumber)), __LINE__);
        }
        $this->SplitPacketNumber = $splitPacketNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SplitSaleOrderItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
