<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchItemTypesRequest StructType
 * @subpackage Structs
 */
class SearchItemTypesRequest extends AbstractStructBase
{
    /**
     * The Keyword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Keyword;
    /**
     * The ProductCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ProductCode;
    /**
     * The CategoryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CategoryCode;
    /**
     * The GetInventorySnapshot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GetInventorySnapshot;
    /**
     * The SearchOptions
     * @var \StructType\SearchOptions
     */
    public $SearchOptions;
    /**
     * Constructor method for SearchItemTypesRequest
     * @uses SearchItemTypesRequest::setKeyword()
     * @uses SearchItemTypesRequest::setProductCode()
     * @uses SearchItemTypesRequest::setCategoryCode()
     * @uses SearchItemTypesRequest::setGetInventorySnapshot()
     * @uses SearchItemTypesRequest::setSearchOptions()
     * @param string $keyword
     * @param string $productCode
     * @param string $categoryCode
     * @param bool $getInventorySnapshot
     * @param \StructType\SearchOptions $searchOptions
     */
    public function __construct($keyword = null, $productCode = null, $categoryCode = null, $getInventorySnapshot = null, \StructType\SearchOptions $searchOptions = null)
    {
        $this
            ->setKeyword($keyword)
            ->setProductCode($productCode)
            ->setCategoryCode($categoryCode)
            ->setGetInventorySnapshot($getInventorySnapshot)
            ->setSearchOptions($searchOptions);
    }
    /**
     * Get Keyword value
     * @return string|null
     */
    public function getKeyword()
    {
        return $this->Keyword;
    }
    /**
     * Set Keyword value
     * @param string $keyword
     * @return \StructType\SearchItemTypesRequest
     */
    public function setKeyword($keyword = null)
    {
        // validation for constraint: string
        if (!is_null($keyword) && !is_string($keyword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyword, true), gettype($keyword)), __LINE__);
        }
        $this->Keyword = $keyword;
        return $this;
    }
    /**
     * Get ProductCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param string $productCode
     * @return \StructType\SearchItemTypesRequest
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get CategoryCode value
     * @return string|null
     */
    public function getCategoryCode()
    {
        return $this->CategoryCode;
    }
    /**
     * Set CategoryCode value
     * @param string $categoryCode
     * @return \StructType\SearchItemTypesRequest
     */
    public function setCategoryCode($categoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($categoryCode) && !is_string($categoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryCode, true), gettype($categoryCode)), __LINE__);
        }
        $this->CategoryCode = $categoryCode;
        return $this;
    }
    /**
     * Get GetInventorySnapshot value
     * @return bool|null
     */
    public function getGetInventorySnapshot()
    {
        return $this->GetInventorySnapshot;
    }
    /**
     * Set GetInventorySnapshot value
     * @param bool $getInventorySnapshot
     * @return \StructType\SearchItemTypesRequest
     */
    public function setGetInventorySnapshot($getInventorySnapshot = null)
    {
        // validation for constraint: boolean
        if (!is_null($getInventorySnapshot) && !is_bool($getInventorySnapshot)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($getInventorySnapshot, true), gettype($getInventorySnapshot)), __LINE__);
        }
        $this->GetInventorySnapshot = $getInventorySnapshot;
        return $this;
    }
    /**
     * Get SearchOptions value
     * @return \StructType\SearchOptions|null
     */
    public function getSearchOptions()
    {
        return $this->SearchOptions;
    }
    /**
     * Set SearchOptions value
     * @param \StructType\SearchOptions $searchOptions
     * @return \StructType\SearchItemTypesRequest
     */
    public function setSearchOptions(\StructType\SearchOptions $searchOptions = null)
    {
        $this->SearchOptions = $searchOptions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchItemTypesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
