<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaleOrderItemAlternate StructType
 * @subpackage Structs
 */
class SaleOrderItemAlternate extends AbstractStructBase
{
    /**
     * The ItemSKU
     * @var string
     */
    public $ItemSKU;
    /**
     * The AmountDifference
     * @var float
     */
    public $AmountDifference;
    /**
     * Constructor method for SaleOrderItemAlternate
     * @uses SaleOrderItemAlternate::setItemSKU()
     * @uses SaleOrderItemAlternate::setAmountDifference()
     * @param string $itemSKU
     * @param float $amountDifference
     */
    public function __construct($itemSKU = null, $amountDifference = null)
    {
        $this
            ->setItemSKU($itemSKU)
            ->setAmountDifference($amountDifference);
    }
    /**
     * Get ItemSKU value
     * @return string|null
     */
    public function getItemSKU()
    {
        return $this->ItemSKU;
    }
    /**
     * Set ItemSKU value
     * @param string $itemSKU
     * @return \StructType\SaleOrderItemAlternate
     */
    public function setItemSKU($itemSKU = null)
    {
        // validation for constraint: string
        if (!is_null($itemSKU) && !is_string($itemSKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemSKU, true), gettype($itemSKU)), __LINE__);
        }
        $this->ItemSKU = $itemSKU;
        return $this;
    }
    /**
     * Get AmountDifference value
     * @return float|null
     */
    public function getAmountDifference()
    {
        return $this->AmountDifference;
    }
    /**
     * Set AmountDifference value
     * @param float $amountDifference
     * @return \StructType\SaleOrderItemAlternate
     */
    public function setAmountDifference($amountDifference = null)
    {
        // validation for constraint: float
        if (!is_null($amountDifference) && !(is_float($amountDifference) || is_numeric($amountDifference))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountDifference, true), gettype($amountDifference)), __LINE__);
        }
        $this->AmountDifference = $amountDifference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SaleOrderItemAlternate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
