<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaleOrderAddress StructType
 * @subpackage Structs
 */
class SaleOrderAddress extends AbstractStructBase
{
    /**
     * The SaleOrderCode
     * @var string
     */
    public $SaleOrderCode;
    /**
     * The Addresses
     * @var \StructType\Addresses
     */
    public $Addresses;
    /**
     * The ShippingAddress
     * @var \StructType\AddressRef
     */
    public $ShippingAddress;
    /**
     * The BillingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AddressRef
     */
    public $BillingAddress;
    /**
     * The SaleOrderAddressItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SaleOrderAddressItems
     */
    public $SaleOrderAddressItems;
    /**
     * Constructor method for SaleOrderAddress
     * @uses SaleOrderAddress::setSaleOrderCode()
     * @uses SaleOrderAddress::setAddresses()
     * @uses SaleOrderAddress::setShippingAddress()
     * @uses SaleOrderAddress::setBillingAddress()
     * @uses SaleOrderAddress::setSaleOrderAddressItems()
     * @param string $saleOrderCode
     * @param \StructType\Addresses $addresses
     * @param \StructType\AddressRef $shippingAddress
     * @param \StructType\AddressRef $billingAddress
     * @param \StructType\SaleOrderAddressItems $saleOrderAddressItems
     */
    public function __construct($saleOrderCode = null, \StructType\Addresses $addresses = null, \StructType\AddressRef $shippingAddress = null, \StructType\AddressRef $billingAddress = null, \StructType\SaleOrderAddressItems $saleOrderAddressItems = null)
    {
        $this
            ->setSaleOrderCode($saleOrderCode)
            ->setAddresses($addresses)
            ->setShippingAddress($shippingAddress)
            ->setBillingAddress($billingAddress)
            ->setSaleOrderAddressItems($saleOrderAddressItems);
    }
    /**
     * Get SaleOrderCode value
     * @return string|null
     */
    public function getSaleOrderCode()
    {
        return $this->SaleOrderCode;
    }
    /**
     * Set SaleOrderCode value
     * @param string $saleOrderCode
     * @return \StructType\SaleOrderAddress
     */
    public function setSaleOrderCode($saleOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleOrderCode) && !is_string($saleOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOrderCode, true), gettype($saleOrderCode)), __LINE__);
        }
        $this->SaleOrderCode = $saleOrderCode;
        return $this;
    }
    /**
     * Get Addresses value
     * @return \StructType\Addresses|null
     */
    public function getAddresses()
    {
        return $this->Addresses;
    }
    /**
     * Set Addresses value
     * @param \StructType\Addresses $addresses
     * @return \StructType\SaleOrderAddress
     */
    public function setAddresses(\StructType\Addresses $addresses = null)
    {
        $this->Addresses = $addresses;
        return $this;
    }
    /**
     * Get ShippingAddress value
     * @return \StructType\AddressRef|null
     */
    public function getShippingAddress()
    {
        return $this->ShippingAddress;
    }
    /**
     * Set ShippingAddress value
     * @param \StructType\AddressRef $shippingAddress
     * @return \StructType\SaleOrderAddress
     */
    public function setShippingAddress(\StructType\AddressRef $shippingAddress = null)
    {
        $this->ShippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return \StructType\AddressRef|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param \StructType\AddressRef $billingAddress
     * @return \StructType\SaleOrderAddress
     */
    public function setBillingAddress(\StructType\AddressRef $billingAddress = null)
    {
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get SaleOrderAddressItems value
     * @return \StructType\SaleOrderAddressItems|null
     */
    public function getSaleOrderAddressItems()
    {
        return $this->SaleOrderAddressItems;
    }
    /**
     * Set SaleOrderAddressItems value
     * @param \StructType\SaleOrderAddressItems $saleOrderAddressItems
     * @return \StructType\SaleOrderAddress
     */
    public function setSaleOrderAddressItems(\StructType\SaleOrderAddressItems $saleOrderAddressItems = null)
    {
        $this->SaleOrderAddressItems = $saleOrderAddressItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SaleOrderAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
