<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseOrderItem StructType
 * @subpackage Structs
 */
class PurchaseOrderItem extends AbstractStructBase
{
    /**
     * The ItemSKU
     * @var string
     */
    public $ItemSKU;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The UnitPrice
     * @var float
     */
    public $UnitPrice;
    /**
     * The MaxRetailPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MaxRetailPrice;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Discount;
    /**
     * The TaxTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TaxTypeCode;
    /**
     * Constructor method for PurchaseOrderItem
     * @uses PurchaseOrderItem::setItemSKU()
     * @uses PurchaseOrderItem::setQuantity()
     * @uses PurchaseOrderItem::setUnitPrice()
     * @uses PurchaseOrderItem::setMaxRetailPrice()
     * @uses PurchaseOrderItem::setDiscount()
     * @uses PurchaseOrderItem::setTaxTypeCode()
     * @param string $itemSKU
     * @param int $quantity
     * @param float $unitPrice
     * @param float $maxRetailPrice
     * @param float $discount
     * @param string $taxTypeCode
     */
    public function __construct($itemSKU = null, $quantity = null, $unitPrice = null, $maxRetailPrice = null, $discount = null, $taxTypeCode = null)
    {
        $this
            ->setItemSKU($itemSKU)
            ->setQuantity($quantity)
            ->setUnitPrice($unitPrice)
            ->setMaxRetailPrice($maxRetailPrice)
            ->setDiscount($discount)
            ->setTaxTypeCode($taxTypeCode);
    }
    /**
     * Get ItemSKU value
     * @return string|null
     */
    public function getItemSKU()
    {
        return $this->ItemSKU;
    }
    /**
     * Set ItemSKU value
     * @param string $itemSKU
     * @return \StructType\PurchaseOrderItem
     */
    public function setItemSKU($itemSKU = null)
    {
        // validation for constraint: string
        if (!is_null($itemSKU) && !is_string($itemSKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemSKU, true), gettype($itemSKU)), __LINE__);
        }
        $this->ItemSKU = $itemSKU;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\PurchaseOrderItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return float|null
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param float $unitPrice
     * @return \StructType\PurchaseOrderItem
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get MaxRetailPrice value
     * @return float|null
     */
    public function getMaxRetailPrice()
    {
        return $this->MaxRetailPrice;
    }
    /**
     * Set MaxRetailPrice value
     * @param float $maxRetailPrice
     * @return \StructType\PurchaseOrderItem
     */
    public function setMaxRetailPrice($maxRetailPrice = null)
    {
        // validation for constraint: float
        if (!is_null($maxRetailPrice) && !(is_float($maxRetailPrice) || is_numeric($maxRetailPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxRetailPrice, true), gettype($maxRetailPrice)), __LINE__);
        }
        $this->MaxRetailPrice = $maxRetailPrice;
        return $this;
    }
    /**
     * Get Discount value
     * @return float|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param float $discount
     * @return \StructType\PurchaseOrderItem
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: float
        if (!is_null($discount) && !(is_float($discount) || is_numeric($discount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get TaxTypeCode value
     * @return string|null
     */
    public function getTaxTypeCode()
    {
        return $this->TaxTypeCode;
    }
    /**
     * Set TaxTypeCode value
     * @param string $taxTypeCode
     * @return \StructType\PurchaseOrderItem
     */
    public function setTaxTypeCode($taxTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxTypeCode) && !is_string($taxTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxTypeCode, true), gettype($taxTypeCode)), __LINE__);
        }
        $this->TaxTypeCode = $taxTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PurchaseOrderItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
