<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarkItemDamagedOutboundQCRequest StructType
 * @subpackage Structs
 */
class MarkItemDamagedOutboundQCRequest extends AbstractStructBase
{
    /**
     * The SaleOrderCode
     * @var string
     */
    public $SaleOrderCode;
    /**
     * The ShippingPackageCode
     * @var string
     */
    public $ShippingPackageCode;
    /**
     * The ItemCode
     * @var string
     */
    public $ItemCode;
    /**
     * The RejectionReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RejectionReason;
    /**
     * Constructor method for MarkItemDamagedOutboundQCRequest
     * @uses MarkItemDamagedOutboundQCRequest::setSaleOrderCode()
     * @uses MarkItemDamagedOutboundQCRequest::setShippingPackageCode()
     * @uses MarkItemDamagedOutboundQCRequest::setItemCode()
     * @uses MarkItemDamagedOutboundQCRequest::setRejectionReason()
     * @param string $saleOrderCode
     * @param string $shippingPackageCode
     * @param string $itemCode
     * @param string $rejectionReason
     */
    public function __construct($saleOrderCode = null, $shippingPackageCode = null, $itemCode = null, $rejectionReason = null)
    {
        $this
            ->setSaleOrderCode($saleOrderCode)
            ->setShippingPackageCode($shippingPackageCode)
            ->setItemCode($itemCode)
            ->setRejectionReason($rejectionReason);
    }
    /**
     * Get SaleOrderCode value
     * @return string|null
     */
    public function getSaleOrderCode()
    {
        return $this->SaleOrderCode;
    }
    /**
     * Set SaleOrderCode value
     * @param string $saleOrderCode
     * @return \StructType\MarkItemDamagedOutboundQCRequest
     */
    public function setSaleOrderCode($saleOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleOrderCode) && !is_string($saleOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOrderCode, true), gettype($saleOrderCode)), __LINE__);
        }
        $this->SaleOrderCode = $saleOrderCode;
        return $this;
    }
    /**
     * Get ShippingPackageCode value
     * @return string|null
     */
    public function getShippingPackageCode()
    {
        return $this->ShippingPackageCode;
    }
    /**
     * Set ShippingPackageCode value
     * @param string $shippingPackageCode
     * @return \StructType\MarkItemDamagedOutboundQCRequest
     */
    public function setShippingPackageCode($shippingPackageCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingPackageCode) && !is_string($shippingPackageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingPackageCode, true), gettype($shippingPackageCode)), __LINE__);
        }
        $this->ShippingPackageCode = $shippingPackageCode;
        return $this;
    }
    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }
    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return \StructType\MarkItemDamagedOutboundQCRequest
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCode, true), gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }
    /**
     * Get RejectionReason value
     * @return string|null
     */
    public function getRejectionReason()
    {
        return $this->RejectionReason;
    }
    /**
     * Set RejectionReason value
     * @param string $rejectionReason
     * @return \StructType\MarkItemDamagedOutboundQCRequest
     */
    public function setRejectionReason($rejectionReason = null)
    {
        // validation for constraint: string
        if (!is_null($rejectionReason) && !is_string($rejectionReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rejectionReason, true), gettype($rejectionReason)), __LINE__);
        }
        $this->RejectionReason = $rejectionReason;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MarkItemDamagedOutboundQCRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
