<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemTypes StructType
 * @subpackage Structs
 */
class ItemTypes extends AbstractStructBase
{
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemType[]
     */
    public $ItemType;
    /**
     * Constructor method for ItemTypes
     * @uses ItemTypes::setItemType()
     * @param \StructType\ItemType[] $itemType
     */
    public function __construct(array $itemType = array())
    {
        $this
            ->setItemType($itemType);
    }
    /**
     * Get ItemType value
     * @return \StructType\ItemType[]|null
     */
    public function getItemType()
    {
        return $this->ItemType;
    }
    /**
     * This method is responsible for validating the values passed to the setItemType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemTypeForArrayConstraintsFromSetItemType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemTypesItemTypeItem) {
            // validation for constraint: itemType
            if (!$itemTypesItemTypeItem instanceof \StructType\ItemType) {
                $invalidValues[] = is_object($itemTypesItemTypeItem) ? get_class($itemTypesItemTypeItem) : sprintf('%s(%s)', gettype($itemTypesItemTypeItem), var_export($itemTypesItemTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemType property can only contain items of type \StructType\ItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemType value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemType[] $itemType
     * @return \StructType\ItemTypes
     */
    public function setItemType(array $itemType = array())
    {
        // validation for constraint: array
        if ('' !== ($itemTypeArrayErrorMessage = self::validateItemTypeForArrayConstraintsFromSetItemType($itemType))) {
            throw new \InvalidArgumentException($itemTypeArrayErrorMessage, __LINE__);
        }
        $this->ItemType = $itemType;
        return $this;
    }
    /**
     * Add item to ItemType value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemType $item
     * @return \StructType\ItemTypes
     */
    public function addToItemType(\StructType\ItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemType) {
            throw new \InvalidArgumentException(sprintf('The ItemType property can only contain items of type \StructType\ItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemType[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemTypes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
