<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemDetail StructType
 * @subpackage Structs
 */
class ItemDetail extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The GRNCode
     * @var string
     */
    public $GRNCode;
    /**
     * The PutawayNumber
     * @var string
     */
    public $PutawayNumber;
    /**
     * The ItemSku
     * @var string
     */
    public $ItemSku;
    /**
     * The ItemTypeName
     * @var string
     */
    public $ItemTypeName;
    /**
     * The VendorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VendorCode;
    /**
     * The VendorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VendorName;
    /**
     * The CreatedOn
     * @var string
     */
    public $CreatedOn;
    /**
     * The UpdatedOn
     * @var string
     */
    public $UpdatedOn;
    /**
     * The CreatedFacility
     * @var string
     */
    public $CreatedFacility;
    /**
     * The CurrentFacility
     * @var string
     */
    public $CurrentFacility;
    /**
     * The UnitPrice
     * @var float
     */
    public $UnitPrice;
    /**
     * The VendorSkuCode
     * @var string
     */
    public $VendorSkuCode;
    /**
     * The Color
     * @var string
     */
    public $Color;
    /**
     * The Brand
     * @var string
     */
    public $Brand;
    /**
     * The Size
     * @var string
     */
    public $Size;
    /**
     * The SaleOrderItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SaleOrderItems
     */
    public $SaleOrderItems;
    /**
     * Constructor method for ItemDetail
     * @uses ItemDetail::setCode()
     * @uses ItemDetail::setStatus()
     * @uses ItemDetail::setGRNCode()
     * @uses ItemDetail::setPutawayNumber()
     * @uses ItemDetail::setItemSku()
     * @uses ItemDetail::setItemTypeName()
     * @uses ItemDetail::setVendorCode()
     * @uses ItemDetail::setVendorName()
     * @uses ItemDetail::setCreatedOn()
     * @uses ItemDetail::setUpdatedOn()
     * @uses ItemDetail::setCreatedFacility()
     * @uses ItemDetail::setCurrentFacility()
     * @uses ItemDetail::setUnitPrice()
     * @uses ItemDetail::setVendorSkuCode()
     * @uses ItemDetail::setColor()
     * @uses ItemDetail::setBrand()
     * @uses ItemDetail::setSize()
     * @uses ItemDetail::setSaleOrderItems()
     * @param string $code
     * @param string $status
     * @param string $gRNCode
     * @param string $putawayNumber
     * @param string $itemSku
     * @param string $itemTypeName
     * @param string $vendorCode
     * @param string $vendorName
     * @param string $createdOn
     * @param string $updatedOn
     * @param string $createdFacility
     * @param string $currentFacility
     * @param float $unitPrice
     * @param string $vendorSkuCode
     * @param string $color
     * @param string $brand
     * @param string $size
     * @param \StructType\SaleOrderItems $saleOrderItems
     */
    public function __construct($code = null, $status = null, $gRNCode = null, $putawayNumber = null, $itemSku = null, $itemTypeName = null, $vendorCode = null, $vendorName = null, $createdOn = null, $updatedOn = null, $createdFacility = null, $currentFacility = null, $unitPrice = null, $vendorSkuCode = null, $color = null, $brand = null, $size = null, \StructType\SaleOrderItems $saleOrderItems = null)
    {
        $this
            ->setCode($code)
            ->setStatus($status)
            ->setGRNCode($gRNCode)
            ->setPutawayNumber($putawayNumber)
            ->setItemSku($itemSku)
            ->setItemTypeName($itemTypeName)
            ->setVendorCode($vendorCode)
            ->setVendorName($vendorName)
            ->setCreatedOn($createdOn)
            ->setUpdatedOn($updatedOn)
            ->setCreatedFacility($createdFacility)
            ->setCurrentFacility($currentFacility)
            ->setUnitPrice($unitPrice)
            ->setVendorSkuCode($vendorSkuCode)
            ->setColor($color)
            ->setBrand($brand)
            ->setSize($size)
            ->setSaleOrderItems($saleOrderItems);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\ItemDetail
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\ItemDetail
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get GRNCode value
     * @return string|null
     */
    public function getGRNCode()
    {
        return $this->GRNCode;
    }
    /**
     * Set GRNCode value
     * @param string $gRNCode
     * @return \StructType\ItemDetail
     */
    public function setGRNCode($gRNCode = null)
    {
        // validation for constraint: string
        if (!is_null($gRNCode) && !is_string($gRNCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gRNCode, true), gettype($gRNCode)), __LINE__);
        }
        $this->GRNCode = $gRNCode;
        return $this;
    }
    /**
     * Get PutawayNumber value
     * @return string|null
     */
    public function getPutawayNumber()
    {
        return $this->PutawayNumber;
    }
    /**
     * Set PutawayNumber value
     * @param string $putawayNumber
     * @return \StructType\ItemDetail
     */
    public function setPutawayNumber($putawayNumber = null)
    {
        // validation for constraint: string
        if (!is_null($putawayNumber) && !is_string($putawayNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($putawayNumber, true), gettype($putawayNumber)), __LINE__);
        }
        $this->PutawayNumber = $putawayNumber;
        return $this;
    }
    /**
     * Get ItemSku value
     * @return string|null
     */
    public function getItemSku()
    {
        return $this->ItemSku;
    }
    /**
     * Set ItemSku value
     * @param string $itemSku
     * @return \StructType\ItemDetail
     */
    public function setItemSku($itemSku = null)
    {
        // validation for constraint: string
        if (!is_null($itemSku) && !is_string($itemSku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemSku, true), gettype($itemSku)), __LINE__);
        }
        $this->ItemSku = $itemSku;
        return $this;
    }
    /**
     * Get ItemTypeName value
     * @return string|null
     */
    public function getItemTypeName()
    {
        return $this->ItemTypeName;
    }
    /**
     * Set ItemTypeName value
     * @param string $itemTypeName
     * @return \StructType\ItemDetail
     */
    public function setItemTypeName($itemTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($itemTypeName) && !is_string($itemTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemTypeName, true), gettype($itemTypeName)), __LINE__);
        }
        $this->ItemTypeName = $itemTypeName;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\ItemDetail
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCode, true), gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get VendorName value
     * @return string|null
     */
    public function getVendorName()
    {
        return $this->VendorName;
    }
    /**
     * Set VendorName value
     * @param string $vendorName
     * @return \StructType\ItemDetail
     */
    public function setVendorName($vendorName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorName) && !is_string($vendorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorName, true), gettype($vendorName)), __LINE__);
        }
        $this->VendorName = $vendorName;
        return $this;
    }
    /**
     * Get CreatedOn value
     * @return string|null
     */
    public function getCreatedOn()
    {
        return $this->CreatedOn;
    }
    /**
     * Set CreatedOn value
     * @param string $createdOn
     * @return \StructType\ItemDetail
     */
    public function setCreatedOn($createdOn = null)
    {
        // validation for constraint: string
        if (!is_null($createdOn) && !is_string($createdOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdOn, true), gettype($createdOn)), __LINE__);
        }
        $this->CreatedOn = $createdOn;
        return $this;
    }
    /**
     * Get UpdatedOn value
     * @return string|null
     */
    public function getUpdatedOn()
    {
        return $this->UpdatedOn;
    }
    /**
     * Set UpdatedOn value
     * @param string $updatedOn
     * @return \StructType\ItemDetail
     */
    public function setUpdatedOn($updatedOn = null)
    {
        // validation for constraint: string
        if (!is_null($updatedOn) && !is_string($updatedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updatedOn, true), gettype($updatedOn)), __LINE__);
        }
        $this->UpdatedOn = $updatedOn;
        return $this;
    }
    /**
     * Get CreatedFacility value
     * @return string|null
     */
    public function getCreatedFacility()
    {
        return $this->CreatedFacility;
    }
    /**
     * Set CreatedFacility value
     * @param string $createdFacility
     * @return \StructType\ItemDetail
     */
    public function setCreatedFacility($createdFacility = null)
    {
        // validation for constraint: string
        if (!is_null($createdFacility) && !is_string($createdFacility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdFacility, true), gettype($createdFacility)), __LINE__);
        }
        $this->CreatedFacility = $createdFacility;
        return $this;
    }
    /**
     * Get CurrentFacility value
     * @return string|null
     */
    public function getCurrentFacility()
    {
        return $this->CurrentFacility;
    }
    /**
     * Set CurrentFacility value
     * @param string $currentFacility
     * @return \StructType\ItemDetail
     */
    public function setCurrentFacility($currentFacility = null)
    {
        // validation for constraint: string
        if (!is_null($currentFacility) && !is_string($currentFacility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentFacility, true), gettype($currentFacility)), __LINE__);
        }
        $this->CurrentFacility = $currentFacility;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return float|null
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param float $unitPrice
     * @return \StructType\ItemDetail
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get VendorSkuCode value
     * @return string|null
     */
    public function getVendorSkuCode()
    {
        return $this->VendorSkuCode;
    }
    /**
     * Set VendorSkuCode value
     * @param string $vendorSkuCode
     * @return \StructType\ItemDetail
     */
    public function setVendorSkuCode($vendorSkuCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorSkuCode) && !is_string($vendorSkuCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorSkuCode, true), gettype($vendorSkuCode)), __LINE__);
        }
        $this->VendorSkuCode = $vendorSkuCode;
        return $this;
    }
    /**
     * Get Color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->Color;
    }
    /**
     * Set Color value
     * @param string $color
     * @return \StructType\ItemDetail
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        $this->Color = $color;
        return $this;
    }
    /**
     * Get Brand value
     * @return string|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @param string $brand
     * @return \StructType\ItemDetail
     */
    public function setBrand($brand = null)
    {
        // validation for constraint: string
        if (!is_null($brand) && !is_string($brand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brand, true), gettype($brand)), __LINE__);
        }
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Get Size value
     * @return string|null
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param string $size
     * @return \StructType\ItemDetail
     */
    public function setSize($size = null)
    {
        // validation for constraint: string
        if (!is_null($size) && !is_string($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->Size = $size;
        return $this;
    }
    /**
     * Get SaleOrderItems value
     * @return \StructType\SaleOrderItems|null
     */
    public function getSaleOrderItems()
    {
        return $this->SaleOrderItems;
    }
    /**
     * Set SaleOrderItems value
     * @param \StructType\SaleOrderItems $saleOrderItems
     * @return \StructType\ItemDetail
     */
    public function setSaleOrderItems(\StructType\SaleOrderItems $saleOrderItems = null)
    {
        $this->SaleOrderItems = $saleOrderItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
