<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventorySnapshots StructType
 * @subpackage Structs
 */
class InventorySnapshots extends AbstractStructBase
{
    /**
     * The InventorySnapshot
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\InventorySnapshot[]
     */
    public $InventorySnapshot;
    /**
     * Constructor method for InventorySnapshots
     * @uses InventorySnapshots::setInventorySnapshot()
     * @param \StructType\InventorySnapshot[] $inventorySnapshot
     */
    public function __construct(array $inventorySnapshot = array())
    {
        $this
            ->setInventorySnapshot($inventorySnapshot);
    }
    /**
     * Get InventorySnapshot value
     * @return \StructType\InventorySnapshot[]|null
     */
    public function getInventorySnapshot()
    {
        return $this->InventorySnapshot;
    }
    /**
     * This method is responsible for validating the values passed to the setInventorySnapshot method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInventorySnapshot method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInventorySnapshotForArrayConstraintsFromSetInventorySnapshot(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inventorySnapshotsInventorySnapshotItem) {
            // validation for constraint: itemType
            if (!$inventorySnapshotsInventorySnapshotItem instanceof \StructType\InventorySnapshot) {
                $invalidValues[] = is_object($inventorySnapshotsInventorySnapshotItem) ? get_class($inventorySnapshotsInventorySnapshotItem) : sprintf('%s(%s)', gettype($inventorySnapshotsInventorySnapshotItem), var_export($inventorySnapshotsInventorySnapshotItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InventorySnapshot property can only contain items of type \StructType\InventorySnapshot, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InventorySnapshot value
     * @throws \InvalidArgumentException
     * @param \StructType\InventorySnapshot[] $inventorySnapshot
     * @return \StructType\InventorySnapshots
     */
    public function setInventorySnapshot(array $inventorySnapshot = array())
    {
        // validation for constraint: array
        if ('' !== ($inventorySnapshotArrayErrorMessage = self::validateInventorySnapshotForArrayConstraintsFromSetInventorySnapshot($inventorySnapshot))) {
            throw new \InvalidArgumentException($inventorySnapshotArrayErrorMessage, __LINE__);
        }
        $this->InventorySnapshot = $inventorySnapshot;
        return $this;
    }
    /**
     * Add item to InventorySnapshot value
     * @throws \InvalidArgumentException
     * @param \StructType\InventorySnapshot $item
     * @return \StructType\InventorySnapshots
     */
    public function addToInventorySnapshot(\StructType\InventorySnapshot $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InventorySnapshot) {
            throw new \InvalidArgumentException(sprintf('The InventorySnapshot property can only contain items of type \StructType\InventorySnapshot, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InventorySnapshot[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InventorySnapshots
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
