<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InflowReceipt StructType
 * @subpackage Structs
 */
class InflowReceipt extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The StatusCode
     * @var string
     */
    public $StatusCode;
    /**
     * The Created
     * @var string
     */
    public $Created;
    /**
     * The CreatedBy
     * @var string
     */
    public $CreatedBy;
    /**
     * The VendorInvoiceNumber
     * @var string
     */
    public $VendorInvoiceNumber;
    /**
     * The VendorInvoiceDate
     * @var string
     */
    public $VendorInvoiceDate;
    /**
     * The PurchaseOrderDTO
     * @var \StructType\PurchaseOrder
     */
    public $PurchaseOrderDTO;
    /**
     * The TotalReceivedAmount
     * @var float
     */
    public $TotalReceivedAmount;
    /**
     * The TotalRejectedAmount
     * @var string
     */
    public $TotalRejectedAmount;
    /**
     * The TotalQuantity
     * @var string
     */
    public $TotalQuantity;
    /**
     * The TotalRejectedQuantity
     * @var string
     */
    public $TotalRejectedQuantity;
    /**
     * The InflowReceiptItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InflowReceiptItems
     */
    public $InflowReceiptItems;
    /**
     * The CustomFields
     * @var \StructType\CustomFields
     */
    public $CustomFields;
    /**
     * Constructor method for InflowReceipt
     * @uses InflowReceipt::setCode()
     * @uses InflowReceipt::setStatusCode()
     * @uses InflowReceipt::setCreated()
     * @uses InflowReceipt::setCreatedBy()
     * @uses InflowReceipt::setVendorInvoiceNumber()
     * @uses InflowReceipt::setVendorInvoiceDate()
     * @uses InflowReceipt::setPurchaseOrderDTO()
     * @uses InflowReceipt::setTotalReceivedAmount()
     * @uses InflowReceipt::setTotalRejectedAmount()
     * @uses InflowReceipt::setTotalQuantity()
     * @uses InflowReceipt::setTotalRejectedQuantity()
     * @uses InflowReceipt::setInflowReceiptItems()
     * @uses InflowReceipt::setCustomFields()
     * @param string $code
     * @param string $statusCode
     * @param string $created
     * @param string $createdBy
     * @param string $vendorInvoiceNumber
     * @param string $vendorInvoiceDate
     * @param \StructType\PurchaseOrder $purchaseOrderDTO
     * @param float $totalReceivedAmount
     * @param string $totalRejectedAmount
     * @param string $totalQuantity
     * @param string $totalRejectedQuantity
     * @param \StructType\InflowReceiptItems $inflowReceiptItems
     * @param \StructType\CustomFields $customFields
     */
    public function __construct($code = null, $statusCode = null, $created = null, $createdBy = null, $vendorInvoiceNumber = null, $vendorInvoiceDate = null, \StructType\PurchaseOrder $purchaseOrderDTO = null, $totalReceivedAmount = null, $totalRejectedAmount = null, $totalQuantity = null, $totalRejectedQuantity = null, \StructType\InflowReceiptItems $inflowReceiptItems = null, \StructType\CustomFields $customFields = null)
    {
        $this
            ->setCode($code)
            ->setStatusCode($statusCode)
            ->setCreated($created)
            ->setCreatedBy($createdBy)
            ->setVendorInvoiceNumber($vendorInvoiceNumber)
            ->setVendorInvoiceDate($vendorInvoiceDate)
            ->setPurchaseOrderDTO($purchaseOrderDTO)
            ->setTotalReceivedAmount($totalReceivedAmount)
            ->setTotalRejectedAmount($totalRejectedAmount)
            ->setTotalQuantity($totalQuantity)
            ->setTotalRejectedQuantity($totalRejectedQuantity)
            ->setInflowReceiptItems($inflowReceiptItems)
            ->setCustomFields($customFields);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\InflowReceipt
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\InflowReceipt
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get Created value
     * @return string|null
     */
    public function getCreated()
    {
        return $this->Created;
    }
    /**
     * Set Created value
     * @param string $created
     * @return \StructType\InflowReceipt
     */
    public function setCreated($created = null)
    {
        // validation for constraint: string
        if (!is_null($created) && !is_string($created)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($created, true), gettype($created)), __LINE__);
        }
        $this->Created = $created;
        return $this;
    }
    /**
     * Get CreatedBy value
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->CreatedBy;
    }
    /**
     * Set CreatedBy value
     * @param string $createdBy
     * @return \StructType\InflowReceipt
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdBy, true), gettype($createdBy)), __LINE__);
        }
        $this->CreatedBy = $createdBy;
        return $this;
    }
    /**
     * Get VendorInvoiceNumber value
     * @return string|null
     */
    public function getVendorInvoiceNumber()
    {
        return $this->VendorInvoiceNumber;
    }
    /**
     * Set VendorInvoiceNumber value
     * @param string $vendorInvoiceNumber
     * @return \StructType\InflowReceipt
     */
    public function setVendorInvoiceNumber($vendorInvoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vendorInvoiceNumber) && !is_string($vendorInvoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorInvoiceNumber, true), gettype($vendorInvoiceNumber)), __LINE__);
        }
        $this->VendorInvoiceNumber = $vendorInvoiceNumber;
        return $this;
    }
    /**
     * Get VendorInvoiceDate value
     * @return string|null
     */
    public function getVendorInvoiceDate()
    {
        return $this->VendorInvoiceDate;
    }
    /**
     * Set VendorInvoiceDate value
     * @param string $vendorInvoiceDate
     * @return \StructType\InflowReceipt
     */
    public function setVendorInvoiceDate($vendorInvoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($vendorInvoiceDate) && !is_string($vendorInvoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorInvoiceDate, true), gettype($vendorInvoiceDate)), __LINE__);
        }
        $this->VendorInvoiceDate = $vendorInvoiceDate;
        return $this;
    }
    /**
     * Get PurchaseOrderDTO value
     * @return \StructType\PurchaseOrder|null
     */
    public function getPurchaseOrderDTO()
    {
        return $this->PurchaseOrderDTO;
    }
    /**
     * Set PurchaseOrderDTO value
     * @param \StructType\PurchaseOrder $purchaseOrderDTO
     * @return \StructType\InflowReceipt
     */
    public function setPurchaseOrderDTO(\StructType\PurchaseOrder $purchaseOrderDTO = null)
    {
        $this->PurchaseOrderDTO = $purchaseOrderDTO;
        return $this;
    }
    /**
     * Get TotalReceivedAmount value
     * @return float|null
     */
    public function getTotalReceivedAmount()
    {
        return $this->TotalReceivedAmount;
    }
    /**
     * Set TotalReceivedAmount value
     * @param float $totalReceivedAmount
     * @return \StructType\InflowReceipt
     */
    public function setTotalReceivedAmount($totalReceivedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalReceivedAmount) && !(is_float($totalReceivedAmount) || is_numeric($totalReceivedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalReceivedAmount, true), gettype($totalReceivedAmount)), __LINE__);
        }
        $this->TotalReceivedAmount = $totalReceivedAmount;
        return $this;
    }
    /**
     * Get TotalRejectedAmount value
     * @return string|null
     */
    public function getTotalRejectedAmount()
    {
        return $this->TotalRejectedAmount;
    }
    /**
     * Set TotalRejectedAmount value
     * @param string $totalRejectedAmount
     * @return \StructType\InflowReceipt
     */
    public function setTotalRejectedAmount($totalRejectedAmount = null)
    {
        // validation for constraint: string
        if (!is_null($totalRejectedAmount) && !is_string($totalRejectedAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalRejectedAmount, true), gettype($totalRejectedAmount)), __LINE__);
        }
        $this->TotalRejectedAmount = $totalRejectedAmount;
        return $this;
    }
    /**
     * Get TotalQuantity value
     * @return string|null
     */
    public function getTotalQuantity()
    {
        return $this->TotalQuantity;
    }
    /**
     * Set TotalQuantity value
     * @param string $totalQuantity
     * @return \StructType\InflowReceipt
     */
    public function setTotalQuantity($totalQuantity = null)
    {
        // validation for constraint: string
        if (!is_null($totalQuantity) && !is_string($totalQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalQuantity, true), gettype($totalQuantity)), __LINE__);
        }
        $this->TotalQuantity = $totalQuantity;
        return $this;
    }
    /**
     * Get TotalRejectedQuantity value
     * @return string|null
     */
    public function getTotalRejectedQuantity()
    {
        return $this->TotalRejectedQuantity;
    }
    /**
     * Set TotalRejectedQuantity value
     * @param string $totalRejectedQuantity
     * @return \StructType\InflowReceipt
     */
    public function setTotalRejectedQuantity($totalRejectedQuantity = null)
    {
        // validation for constraint: string
        if (!is_null($totalRejectedQuantity) && !is_string($totalRejectedQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalRejectedQuantity, true), gettype($totalRejectedQuantity)), __LINE__);
        }
        $this->TotalRejectedQuantity = $totalRejectedQuantity;
        return $this;
    }
    /**
     * Get InflowReceiptItems value
     * @return \StructType\InflowReceiptItems|null
     */
    public function getInflowReceiptItems()
    {
        return $this->InflowReceiptItems;
    }
    /**
     * Set InflowReceiptItems value
     * @param \StructType\InflowReceiptItems $inflowReceiptItems
     * @return \StructType\InflowReceipt
     */
    public function setInflowReceiptItems(\StructType\InflowReceiptItems $inflowReceiptItems = null)
    {
        $this->InflowReceiptItems = $inflowReceiptItems;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \StructType\CustomFields|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \StructType\CustomFields $customFields
     * @return \StructType\InflowReceipt
     */
    public function setCustomFields(\StructType\CustomFields $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InflowReceipt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
