<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetItemDetailResponse StructType
 * @subpackage Structs
 */
class GetItemDetailResponse extends AbstractStructBase
{
    /**
     * The Successful
     * @var bool
     */
    public $Successful;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Errors
     */
    public $Errors;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Warnings
     */
    public $Warnings;
    /**
     * The ItemDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ItemDetail[]
     */
    public $ItemDetail;
    /**
     * Constructor method for GetItemDetailResponse
     * @uses GetItemDetailResponse::setSuccessful()
     * @uses GetItemDetailResponse::setErrors()
     * @uses GetItemDetailResponse::setWarnings()
     * @uses GetItemDetailResponse::setItemDetail()
     * @param bool $successful
     * @param \StructType\Errors $errors
     * @param \StructType\Warnings $warnings
     * @param \StructType\ItemDetail[] $itemDetail
     */
    public function __construct($successful = null, \StructType\Errors $errors = null, \StructType\Warnings $warnings = null, array $itemDetail = array())
    {
        $this
            ->setSuccessful($successful)
            ->setErrors($errors)
            ->setWarnings($warnings)
            ->setItemDetail($itemDetail);
    }
    /**
     * Get Successful value
     * @return bool|null
     */
    public function getSuccessful()
    {
        return $this->Successful;
    }
    /**
     * Set Successful value
     * @param bool $successful
     * @return \StructType\GetItemDetailResponse
     */
    public function setSuccessful($successful = null)
    {
        // validation for constraint: boolean
        if (!is_null($successful) && !is_bool($successful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successful, true), gettype($successful)), __LINE__);
        }
        $this->Successful = $successful;
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\Errors|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \StructType\Errors $errors
     * @return \StructType\GetItemDetailResponse
     */
    public function setErrors(\StructType\Errors $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\Warnings|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \StructType\Warnings $warnings
     * @return \StructType\GetItemDetailResponse
     */
    public function setWarnings(\StructType\Warnings $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get ItemDetail value
     * @return \StructType\ItemDetail[]|null
     */
    public function getItemDetail()
    {
        return $this->ItemDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setItemDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemDetailForArrayConstraintsFromSetItemDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getItemDetailResponseItemDetailItem) {
            // validation for constraint: itemType
            if (!$getItemDetailResponseItemDetailItem instanceof \StructType\ItemDetail) {
                $invalidValues[] = is_object($getItemDetailResponseItemDetailItem) ? get_class($getItemDetailResponseItemDetailItem) : sprintf('%s(%s)', gettype($getItemDetailResponseItemDetailItem), var_export($getItemDetailResponseItemDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemDetail property can only contain items of type \StructType\ItemDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemDetail[] $itemDetail
     * @return \StructType\GetItemDetailResponse
     */
    public function setItemDetail(array $itemDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($itemDetailArrayErrorMessage = self::validateItemDetailForArrayConstraintsFromSetItemDetail($itemDetail))) {
            throw new \InvalidArgumentException($itemDetailArrayErrorMessage, __LINE__);
        }
        $this->ItemDetail = $itemDetail;
        return $this;
    }
    /**
     * Add item to ItemDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemDetail $item
     * @return \StructType\GetItemDetailResponse
     */
    public function addToItemDetail(\StructType\ItemDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemDetail) {
            throw new \InvalidArgumentException(sprintf('The ItemDetail property can only contain items of type \StructType\ItemDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetItemDetailResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
