<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInflowReceiptDetailResponse StructType
 * @subpackage Structs
 */
class GetInflowReceiptDetailResponse extends AbstractStructBase
{
    /**
     * The InflowReceipt
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InflowReceipt[]
     */
    public $InflowReceipt;
    /**
     * The VendorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VendorCode;
    /**
     * Constructor method for GetInflowReceiptDetailResponse
     * @uses GetInflowReceiptDetailResponse::setInflowReceipt()
     * @uses GetInflowReceiptDetailResponse::setVendorCode()
     * @param \StructType\InflowReceipt[] $inflowReceipt
     * @param string $vendorCode
     */
    public function __construct(array $inflowReceipt = array(), $vendorCode = null)
    {
        $this
            ->setInflowReceipt($inflowReceipt)
            ->setVendorCode($vendorCode);
    }
    /**
     * Get InflowReceipt value
     * @return \StructType\InflowReceipt[]|null
     */
    public function getInflowReceipt()
    {
        return $this->InflowReceipt;
    }
    /**
     * This method is responsible for validating the values passed to the setInflowReceipt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInflowReceipt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInflowReceiptForArrayConstraintsFromSetInflowReceipt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getInflowReceiptDetailResponseInflowReceiptItem) {
            // validation for constraint: itemType
            if (!$getInflowReceiptDetailResponseInflowReceiptItem instanceof \StructType\InflowReceipt) {
                $invalidValues[] = is_object($getInflowReceiptDetailResponseInflowReceiptItem) ? get_class($getInflowReceiptDetailResponseInflowReceiptItem) : sprintf('%s(%s)', gettype($getInflowReceiptDetailResponseInflowReceiptItem), var_export($getInflowReceiptDetailResponseInflowReceiptItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InflowReceipt property can only contain items of type \StructType\InflowReceipt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InflowReceipt value
     * @throws \InvalidArgumentException
     * @param \StructType\InflowReceipt[] $inflowReceipt
     * @return \StructType\GetInflowReceiptDetailResponse
     */
    public function setInflowReceipt(array $inflowReceipt = array())
    {
        // validation for constraint: array
        if ('' !== ($inflowReceiptArrayErrorMessage = self::validateInflowReceiptForArrayConstraintsFromSetInflowReceipt($inflowReceipt))) {
            throw new \InvalidArgumentException($inflowReceiptArrayErrorMessage, __LINE__);
        }
        $this->InflowReceipt = $inflowReceipt;
        return $this;
    }
    /**
     * Add item to InflowReceipt value
     * @throws \InvalidArgumentException
     * @param \StructType\InflowReceipt $item
     * @return \StructType\GetInflowReceiptDetailResponse
     */
    public function addToInflowReceipt(\StructType\InflowReceipt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InflowReceipt) {
            throw new \InvalidArgumentException(sprintf('The InflowReceipt property can only contain items of type \StructType\InflowReceipt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InflowReceipt[] = $item;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\GetInflowReceiptDetailResponse
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCode, true), gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetInflowReceiptDetailResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
