<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditShippingPackageRequest StructType
 * @subpackage Structs
 */
class EditShippingPackageRequest extends AbstractStructBase
{
    /**
     * The ShippingPackageCode
     * @var string
     */
    public $ShippingPackageCode;
    /**
     * The ShippingProviderCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShippingProviderCode;
    /**
     * The TrackingNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumber;
    /**
     * The ShippingPackageTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShippingPackageTypeCode;
    /**
     * The ActualWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ActualWeight;
    /**
     * The ShippingBox
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\WsShippingBox
     */
    public $ShippingBox;
    /**
     * The NoOfBoxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NoOfBoxes;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFields
     */
    public $CustomFields;
    /**
     * Constructor method for EditShippingPackageRequest
     * @uses EditShippingPackageRequest::setShippingPackageCode()
     * @uses EditShippingPackageRequest::setShippingProviderCode()
     * @uses EditShippingPackageRequest::setTrackingNumber()
     * @uses EditShippingPackageRequest::setShippingPackageTypeCode()
     * @uses EditShippingPackageRequest::setActualWeight()
     * @uses EditShippingPackageRequest::setShippingBox()
     * @uses EditShippingPackageRequest::setNoOfBoxes()
     * @uses EditShippingPackageRequest::setCustomFields()
     * @param string $shippingPackageCode
     * @param string $shippingProviderCode
     * @param string $trackingNumber
     * @param string $shippingPackageTypeCode
     * @param float $actualWeight
     * @param \StructType\WsShippingBox $shippingBox
     * @param int $noOfBoxes
     * @param \StructType\CustomFields $customFields
     */
    public function __construct($shippingPackageCode = null, $shippingProviderCode = null, $trackingNumber = null, $shippingPackageTypeCode = null, $actualWeight = null, \StructType\WsShippingBox $shippingBox = null, $noOfBoxes = null, \StructType\CustomFields $customFields = null)
    {
        $this
            ->setShippingPackageCode($shippingPackageCode)
            ->setShippingProviderCode($shippingProviderCode)
            ->setTrackingNumber($trackingNumber)
            ->setShippingPackageTypeCode($shippingPackageTypeCode)
            ->setActualWeight($actualWeight)
            ->setShippingBox($shippingBox)
            ->setNoOfBoxes($noOfBoxes)
            ->setCustomFields($customFields);
    }
    /**
     * Get ShippingPackageCode value
     * @return string|null
     */
    public function getShippingPackageCode()
    {
        return $this->ShippingPackageCode;
    }
    /**
     * Set ShippingPackageCode value
     * @param string $shippingPackageCode
     * @return \StructType\EditShippingPackageRequest
     */
    public function setShippingPackageCode($shippingPackageCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingPackageCode) && !is_string($shippingPackageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingPackageCode, true), gettype($shippingPackageCode)), __LINE__);
        }
        $this->ShippingPackageCode = $shippingPackageCode;
        return $this;
    }
    /**
     * Get ShippingProviderCode value
     * @return string|null
     */
    public function getShippingProviderCode()
    {
        return $this->ShippingProviderCode;
    }
    /**
     * Set ShippingProviderCode value
     * @param string $shippingProviderCode
     * @return \StructType\EditShippingPackageRequest
     */
    public function setShippingProviderCode($shippingProviderCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingProviderCode) && !is_string($shippingProviderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingProviderCode, true), gettype($shippingProviderCode)), __LINE__);
        }
        $this->ShippingProviderCode = $shippingProviderCode;
        return $this;
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \StructType\EditShippingPackageRequest
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get ShippingPackageTypeCode value
     * @return string|null
     */
    public function getShippingPackageTypeCode()
    {
        return $this->ShippingPackageTypeCode;
    }
    /**
     * Set ShippingPackageTypeCode value
     * @param string $shippingPackageTypeCode
     * @return \StructType\EditShippingPackageRequest
     */
    public function setShippingPackageTypeCode($shippingPackageTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingPackageTypeCode) && !is_string($shippingPackageTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingPackageTypeCode, true), gettype($shippingPackageTypeCode)), __LINE__);
        }
        $this->ShippingPackageTypeCode = $shippingPackageTypeCode;
        return $this;
    }
    /**
     * Get ActualWeight value
     * @return float|null
     */
    public function getActualWeight()
    {
        return $this->ActualWeight;
    }
    /**
     * Set ActualWeight value
     * @param float $actualWeight
     * @return \StructType\EditShippingPackageRequest
     */
    public function setActualWeight($actualWeight = null)
    {
        // validation for constraint: float
        if (!is_null($actualWeight) && !(is_float($actualWeight) || is_numeric($actualWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($actualWeight, true), gettype($actualWeight)), __LINE__);
        }
        $this->ActualWeight = $actualWeight;
        return $this;
    }
    /**
     * Get ShippingBox value
     * @return \StructType\WsShippingBox|null
     */
    public function getShippingBox()
    {
        return $this->ShippingBox;
    }
    /**
     * Set ShippingBox value
     * @param \StructType\WsShippingBox $shippingBox
     * @return \StructType\EditShippingPackageRequest
     */
    public function setShippingBox(\StructType\WsShippingBox $shippingBox = null)
    {
        $this->ShippingBox = $shippingBox;
        return $this;
    }
    /**
     * Get NoOfBoxes value
     * @return int|null
     */
    public function getNoOfBoxes()
    {
        return $this->NoOfBoxes;
    }
    /**
     * Set NoOfBoxes value
     * @param int $noOfBoxes
     * @return \StructType\EditShippingPackageRequest
     */
    public function setNoOfBoxes($noOfBoxes = null)
    {
        // validation for constraint: int
        if (!is_null($noOfBoxes) && !(is_int($noOfBoxes) || ctype_digit($noOfBoxes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($noOfBoxes, true), gettype($noOfBoxes)), __LINE__);
        }
        $this->NoOfBoxes = $noOfBoxes;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \StructType\CustomFields|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \StructType\CustomFields $customFields
     * @return \StructType\EditShippingPackageRequest
     */
    public function setCustomFields(\StructType\CustomFields $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditShippingPackageRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
