<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateInvoiceAndAllocateShippingProviderResponse
 * StructType
 * @subpackage Structs
 */
class CreateInvoiceAndAllocateShippingProviderResponse extends AbstractStructBase
{
    /**
     * The Successful
     * @var bool
     */
    public $Successful;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Errors
     */
    public $Errors;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Warnings
     */
    public $Warnings;
    /**
     * The InvoiceCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceCode;
    /**
     * The ShippingPackageCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShippingPackageCode;
    /**
     * The ShippingProviderCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShippingProviderCode;
    /**
     * The TrackingNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumber;
    /**
     * The ShippingLabelLink
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShippingLabelLink;
    /**
     * Constructor method for CreateInvoiceAndAllocateShippingProviderResponse
     * @uses CreateInvoiceAndAllocateShippingProviderResponse::setSuccessful()
     * @uses CreateInvoiceAndAllocateShippingProviderResponse::setErrors()
     * @uses CreateInvoiceAndAllocateShippingProviderResponse::setWarnings()
     * @uses CreateInvoiceAndAllocateShippingProviderResponse::setInvoiceCode()
     * @uses CreateInvoiceAndAllocateShippingProviderResponse::setShippingPackageCode()
     * @uses CreateInvoiceAndAllocateShippingProviderResponse::setShippingProviderCode()
     * @uses CreateInvoiceAndAllocateShippingProviderResponse::setTrackingNumber()
     * @uses CreateInvoiceAndAllocateShippingProviderResponse::setShippingLabelLink()
     * @param bool $successful
     * @param \StructType\Errors $errors
     * @param \StructType\Warnings $warnings
     * @param string $invoiceCode
     * @param string $shippingPackageCode
     * @param string $shippingProviderCode
     * @param string $trackingNumber
     * @param string $shippingLabelLink
     */
    public function __construct($successful = null, \StructType\Errors $errors = null, \StructType\Warnings $warnings = null, $invoiceCode = null, $shippingPackageCode = null, $shippingProviderCode = null, $trackingNumber = null, $shippingLabelLink = null)
    {
        $this
            ->setSuccessful($successful)
            ->setErrors($errors)
            ->setWarnings($warnings)
            ->setInvoiceCode($invoiceCode)
            ->setShippingPackageCode($shippingPackageCode)
            ->setShippingProviderCode($shippingProviderCode)
            ->setTrackingNumber($trackingNumber)
            ->setShippingLabelLink($shippingLabelLink);
    }
    /**
     * Get Successful value
     * @return bool|null
     */
    public function getSuccessful()
    {
        return $this->Successful;
    }
    /**
     * Set Successful value
     * @param bool $successful
     * @return \StructType\CreateInvoiceAndAllocateShippingProviderResponse
     */
    public function setSuccessful($successful = null)
    {
        // validation for constraint: boolean
        if (!is_null($successful) && !is_bool($successful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successful, true), gettype($successful)), __LINE__);
        }
        $this->Successful = $successful;
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\Errors|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \StructType\Errors $errors
     * @return \StructType\CreateInvoiceAndAllocateShippingProviderResponse
     */
    public function setErrors(\StructType\Errors $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\Warnings|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \StructType\Warnings $warnings
     * @return \StructType\CreateInvoiceAndAllocateShippingProviderResponse
     */
    public function setWarnings(\StructType\Warnings $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get InvoiceCode value
     * @return string|null
     */
    public function getInvoiceCode()
    {
        return $this->InvoiceCode;
    }
    /**
     * Set InvoiceCode value
     * @param string $invoiceCode
     * @return \StructType\CreateInvoiceAndAllocateShippingProviderResponse
     */
    public function setInvoiceCode($invoiceCode = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceCode) && !is_string($invoiceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceCode, true), gettype($invoiceCode)), __LINE__);
        }
        $this->InvoiceCode = $invoiceCode;
        return $this;
    }
    /**
     * Get ShippingPackageCode value
     * @return string|null
     */
    public function getShippingPackageCode()
    {
        return $this->ShippingPackageCode;
    }
    /**
     * Set ShippingPackageCode value
     * @param string $shippingPackageCode
     * @return \StructType\CreateInvoiceAndAllocateShippingProviderResponse
     */
    public function setShippingPackageCode($shippingPackageCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingPackageCode) && !is_string($shippingPackageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingPackageCode, true), gettype($shippingPackageCode)), __LINE__);
        }
        $this->ShippingPackageCode = $shippingPackageCode;
        return $this;
    }
    /**
     * Get ShippingProviderCode value
     * @return string|null
     */
    public function getShippingProviderCode()
    {
        return $this->ShippingProviderCode;
    }
    /**
     * Set ShippingProviderCode value
     * @param string $shippingProviderCode
     * @return \StructType\CreateInvoiceAndAllocateShippingProviderResponse
     */
    public function setShippingProviderCode($shippingProviderCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingProviderCode) && !is_string($shippingProviderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingProviderCode, true), gettype($shippingProviderCode)), __LINE__);
        }
        $this->ShippingProviderCode = $shippingProviderCode;
        return $this;
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \StructType\CreateInvoiceAndAllocateShippingProviderResponse
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get ShippingLabelLink value
     * @return string|null
     */
    public function getShippingLabelLink()
    {
        return $this->ShippingLabelLink;
    }
    /**
     * Set ShippingLabelLink value
     * @param string $shippingLabelLink
     * @return \StructType\CreateInvoiceAndAllocateShippingProviderResponse
     */
    public function setShippingLabelLink($shippingLabelLink = null)
    {
        // validation for constraint: string
        if (!is_null($shippingLabelLink) && !is_string($shippingLabelLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingLabelLink, true), gettype($shippingLabelLink)), __LINE__);
        }
        $this->ShippingLabelLink = $shippingLabelLink;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateInvoiceAndAllocateShippingProviderResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
