<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateExportJobRequest StructType
 * @subpackage Structs
 */
class CreateExportJobRequest extends AbstractStructBase
{
    /**
     * The ExportJobTypeName
     * @var string
     */
    public $ExportJobTypeName;
    /**
     * The ExportColumns
     * @var \StructType\ExportColumns
     */
    public $ExportColumns;
    /**
     * The ExportFilters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExportFilters
     */
    public $ExportFilters;
    /**
     * The ScheduleTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ScheduleTime;
    /**
     * The NotificationEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NotificationEmail;
    /**
     * The Frequency
     * @var string
     */
    public $Frequency;
    /**
     * Constructor method for CreateExportJobRequest
     * @uses CreateExportJobRequest::setExportJobTypeName()
     * @uses CreateExportJobRequest::setExportColumns()
     * @uses CreateExportJobRequest::setExportFilters()
     * @uses CreateExportJobRequest::setScheduleTime()
     * @uses CreateExportJobRequest::setNotificationEmail()
     * @uses CreateExportJobRequest::setFrequency()
     * @param string $exportJobTypeName
     * @param \StructType\ExportColumns $exportColumns
     * @param \StructType\ExportFilters $exportFilters
     * @param string $scheduleTime
     * @param string $notificationEmail
     * @param string $frequency
     */
    public function __construct($exportJobTypeName = null, \StructType\ExportColumns $exportColumns = null, \StructType\ExportFilters $exportFilters = null, $scheduleTime = null, $notificationEmail = null, $frequency = null)
    {
        $this
            ->setExportJobTypeName($exportJobTypeName)
            ->setExportColumns($exportColumns)
            ->setExportFilters($exportFilters)
            ->setScheduleTime($scheduleTime)
            ->setNotificationEmail($notificationEmail)
            ->setFrequency($frequency);
    }
    /**
     * Get ExportJobTypeName value
     * @return string|null
     */
    public function getExportJobTypeName()
    {
        return $this->ExportJobTypeName;
    }
    /**
     * Set ExportJobTypeName value
     * @param string $exportJobTypeName
     * @return \StructType\CreateExportJobRequest
     */
    public function setExportJobTypeName($exportJobTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($exportJobTypeName) && !is_string($exportJobTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportJobTypeName, true), gettype($exportJobTypeName)), __LINE__);
        }
        $this->ExportJobTypeName = $exportJobTypeName;
        return $this;
    }
    /**
     * Get ExportColumns value
     * @return \StructType\ExportColumns|null
     */
    public function getExportColumns()
    {
        return $this->ExportColumns;
    }
    /**
     * Set ExportColumns value
     * @param \StructType\ExportColumns $exportColumns
     * @return \StructType\CreateExportJobRequest
     */
    public function setExportColumns(\StructType\ExportColumns $exportColumns = null)
    {
        $this->ExportColumns = $exportColumns;
        return $this;
    }
    /**
     * Get ExportFilters value
     * @return \StructType\ExportFilters|null
     */
    public function getExportFilters()
    {
        return $this->ExportFilters;
    }
    /**
     * Set ExportFilters value
     * @param \StructType\ExportFilters $exportFilters
     * @return \StructType\CreateExportJobRequest
     */
    public function setExportFilters(\StructType\ExportFilters $exportFilters = null)
    {
        $this->ExportFilters = $exportFilters;
        return $this;
    }
    /**
     * Get ScheduleTime value
     * @return string|null
     */
    public function getScheduleTime()
    {
        return $this->ScheduleTime;
    }
    /**
     * Set ScheduleTime value
     * @param string $scheduleTime
     * @return \StructType\CreateExportJobRequest
     */
    public function setScheduleTime($scheduleTime = null)
    {
        // validation for constraint: string
        if (!is_null($scheduleTime) && !is_string($scheduleTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduleTime, true), gettype($scheduleTime)), __LINE__);
        }
        $this->ScheduleTime = $scheduleTime;
        return $this;
    }
    /**
     * Get NotificationEmail value
     * @return string|null
     */
    public function getNotificationEmail()
    {
        return $this->NotificationEmail;
    }
    /**
     * Set NotificationEmail value
     * @param string $notificationEmail
     * @return \StructType\CreateExportJobRequest
     */
    public function setNotificationEmail($notificationEmail = null)
    {
        // validation for constraint: string
        if (!is_null($notificationEmail) && !is_string($notificationEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationEmail, true), gettype($notificationEmail)), __LINE__);
        }
        $this->NotificationEmail = $notificationEmail;
        return $this;
    }
    /**
     * Get Frequency value
     * @return string|null
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @param string $frequency
     * @return \StructType\CreateExportJobRequest
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: string
        if (!is_null($frequency) && !is_string($frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequency, true), gettype($frequency)), __LINE__);
        }
        $this->Frequency = $frequency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateExportJobRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
