<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddItemToInflowReceiptRequest StructType
 * @subpackage Structs
 */
class AddItemToInflowReceiptRequest extends AbstractStructBase
{
    /**
     * The InflowReceiptCode
     * @var string
     */
    public $InflowReceiptCode;
    /**
     * The ItemCode
     * @var string
     */
    public $ItemCode;
    /**
     * Constructor method for AddItemToInflowReceiptRequest
     * @uses AddItemToInflowReceiptRequest::setInflowReceiptCode()
     * @uses AddItemToInflowReceiptRequest::setItemCode()
     * @param string $inflowReceiptCode
     * @param string $itemCode
     */
    public function __construct($inflowReceiptCode = null, $itemCode = null)
    {
        $this
            ->setInflowReceiptCode($inflowReceiptCode)
            ->setItemCode($itemCode);
    }
    /**
     * Get InflowReceiptCode value
     * @return string|null
     */
    public function getInflowReceiptCode()
    {
        return $this->InflowReceiptCode;
    }
    /**
     * Set InflowReceiptCode value
     * @param string $inflowReceiptCode
     * @return \StructType\AddItemToInflowReceiptRequest
     */
    public function setInflowReceiptCode($inflowReceiptCode = null)
    {
        // validation for constraint: string
        if (!is_null($inflowReceiptCode) && !is_string($inflowReceiptCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inflowReceiptCode, true), gettype($inflowReceiptCode)), __LINE__);
        }
        $this->InflowReceiptCode = $inflowReceiptCode;
        return $this;
    }
    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }
    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return \StructType\AddItemToInflowReceiptRequest
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCode, true), gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddItemToInflowReceiptRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
