<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unblock ServiceType
 * @subpackage Services
 */
class Unblock extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UnblockSaleOrderItemsInventory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UnblockSaleOrderItemsInventoryRequest $unblockSaleOrderItemsInventoryRequest
     * @return \StructType\UnblockSaleOrderItemsInventoryResponse|bool
     */
    public function UnblockSaleOrderItemsInventory(\StructType\UnblockSaleOrderItemsInventoryRequest $unblockSaleOrderItemsInventoryRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->UnblockSaleOrderItemsInventory($unblockSaleOrderItemsInventoryRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UnblockSaleOrderItemsInventoryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
