<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddEditVendorInvoiceItem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddEditVendorInvoiceItemRequest $addEditVendorInvoiceItemRequest
     * @return \StructType\AddEditVendorInvoiceItemResponse|bool
     */
    public function AddEditVendorInvoiceItem(\StructType\AddEditVendorInvoiceItemRequest $addEditVendorInvoiceItemRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AddEditVendorInvoiceItem($addEditVendorInvoiceItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddItemToGatePass
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddItemToGatePassRequest $addItemToGatePassRequest
     * @return \StructType\AddItemToGatePassResponse|bool
     */
    public function AddItemToGatePass(\StructType\AddItemToGatePassRequest $addItemToGatePassRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AddItemToGatePass($addItemToGatePassRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddItemToInflowReceipt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddItemToInflowReceiptRequest $addItemToInflowReceiptRequest
     * @return \StructType\AddItemToInflowReceiptResponse|bool
     */
    public function AddItemToInflowReceipt(\StructType\AddItemToInflowReceiptRequest $addItemToInflowReceiptRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AddItemToInflowReceipt($addItemToInflowReceiptRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddShipmentsToBatch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddShipmentsToBatchRequest $addShipmentsToBatchRequest
     * @return \StructType\AddShipmentsToBatchResponse|bool
     */
    public function AddShipmentsToBatch(\StructType\AddShipmentsToBatchRequest $addShipmentsToBatchRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AddShipmentsToBatch($addShipmentsToBatchRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddPurchaseOrderItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddPurchaseOrderItemsRequest $addPurchaseOrderItemsRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function AddPurchaseOrderItems(\StructType\AddPurchaseOrderItemsRequest $addPurchaseOrderItemsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AddPurchaseOrderItems($addPurchaseOrderItemsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddOrEditItemLabels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddOrEditItemLabelsRequest $addOrEditItemLabelsRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function AddOrEditItemLabels(\StructType\AddOrEditItemLabelsRequest $addOrEditItemLabelsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AddOrEditItemLabels($addOrEditItemLabelsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddEditVendorInvoiceItemResponse|\StructType\AddItemToGatePassResponse|\StructType\AddItemToInflowReceiptResponse|\StructType\AddShipmentsToBatchResponse|\StructType\ServiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
