<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://demostaging.unicommerce.com/services/soap/uniware16.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://demostaging.unicommerce.com/services/soap/uniware16.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Unhold ServiceType
 */
$unhold = new \ServiceType\Unhold($options);
/**
 * Sample call for UnholdSaleOrder operation/method
 */
if ($unhold->UnholdSaleOrder(new \StructType\UnholdSaleOrderRequest()) !== false) {
    print_r($unhold->getResult());
} else {
    print_r($unhold->getLastError());
}
/**
 * Sample call for UnholdSaleOrderItems operation/method
 */
if ($unhold->UnholdSaleOrderItems(new \StructType\UnholdSaleOrderItemsRequest()) !== false) {
    print_r($unhold->getResult());
} else {
    print_r($unhold->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for CreateSaleOrder operation/method
 */
if ($create->CreateSaleOrder(new \StructType\CreateSaleOrderRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateGatePass operation/method
 */
if ($create->CreateGatePass(new \StructType\CreateGatePassRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateCustomer operation/method
 */
if ($create->CreateCustomer(new \StructType\CreateCustomerRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateFacility operation/method
 */
if ($create->CreateFacility(new \StructType\CreateFacilityRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateOrEditVendor operation/method
 */
if ($create->CreateOrEditVendor(new \StructType\Vendor()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateOrEditVendorItemType operation/method
 */
if ($create->CreateOrEditVendorItemType(new \StructType\VendorItemType()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateSaleOrderItemAlternate operation/method
 */
if ($create->CreateSaleOrderItemAlternate(new \StructType\CreateSaleOrderItemAlternateRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateVendorItemType operation/method
 */
if ($create->CreateVendorItemType(new \StructType\VendorItemType()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateASN operation/method
 */
if ($create->CreateASN(new \StructType\CreateASNRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateExportJob operation/method
 */
if ($create->CreateExportJob(new \StructType\CreateExportJobRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateOrEditItemType operation/method
 */
if ($create->CreateOrEditItemType(new \StructType\ItemTypeRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateItemType operation/method
 */
if ($create->CreateItemType(new \StructType\ItemTypeRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateReversePickup operation/method
 */
if ($create->CreateReversePickup(new \StructType\CreateReversePickupRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateOrEditCategory operation/method
 */
if ($create->CreateOrEditCategory(new \StructType\CreateOrEditCategoryRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePurchaseOrder operation/method
 */
if ($create->CreatePurchaseOrder(new \StructType\CreatePurchaseOrderRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateInvoiceAndAllocateShippingProvider operation/method
 */
if ($create->CreateInvoiceAndAllocateShippingProvider(new \StructType\CreateInvoiceAndAllocateShippingProviderRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateInflowReceipt operation/method
 */
if ($create->CreateInflowReceipt(new \StructType\CreateInflowReceiptRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateOrEditFacilityItemType operation/method
 */
if ($create->CreateOrEditFacilityItemType(new \StructType\CreateOrEditFacilityItemTypeRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateApprovedPurchaseOrder operation/method
 */
if ($create->CreateApprovedPurchaseOrder(new \StructType\CreateApprovedPurchaseOrderRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateVendorCreditInvoice operation/method
 */
if ($create->CreateVendorCreditInvoice(new \StructType\CreateVendorCreditInvoiceRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateVendorDetails operation/method
 */
if ($create->CreateVendorDetails(new \StructType\CreateVendorDetailsRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetItemTypeDetail operation/method
 */
if ($get->GetItemTypeDetail(new \StructType\GetItemTypeDetailRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTaxTypeConfiguration operation/method
 */
if ($get->GetTaxTypeConfiguration(new \StructType\GetTaxTypeConfigurationRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPurchaseOrders operation/method
 */
if ($get->GetPurchaseOrders(new \StructType\GetPurchaseOrdersRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBackOrderItems operation/method
 */
if ($get->GetBackOrderItems(new \StructType\GetBackOrderItemsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetExportJobStatus operation/method
 */
if ($get->GetExportJobStatus(new \StructType\GetExportJobStatusRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetItemDetail operation/method
 */
if ($get->GetItemDetail(new \StructType\GetItemDetailRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInventorySnapshot operation/method
 */
if ($get->GetInventorySnapshot(new \StructType\GetInventorySnapshotRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetItemTypeInventory operation/method
 */
if ($get->GetItemTypeInventory(new \StructType\GetItemTypeInventoryRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetServiceability operation/method
 */
if ($get->GetServiceability(new \StructType\GetServiceabilityRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSaleOrder operation/method
 */
if ($get->GetSaleOrder(new \StructType\GetSaleOrderRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInflowReceiptDetail operation/method
 */
if ($get->GetInflowReceiptDetail(new \StructType\GetInflowReceiptDetailRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVendorItemTypes operation/method
 */
if ($get->GetVendorItemTypes(new \StructType\GetVendorItemTypesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPurchaseOrderDetail operation/method
 */
if ($get->GetPurchaseOrderDetail(new \StructType\GetPurchaseOrderDetailRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetShippingManifest operation/method
 */
if ($get->GetShippingManifest(new \StructType\GetShippingManifestRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInflowReceipts operation/method
 */
if ($get->GetInflowReceipts(new \StructType\GetInflowReceiptsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddEditVendorInvoiceItem operation/method
 */
if ($add->AddEditVendorInvoiceItem(new \StructType\AddEditVendorInvoiceItemRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddItemToGatePass operation/method
 */
if ($add->AddItemToGatePass(new \StructType\AddItemToGatePassRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddItemToInflowReceipt operation/method
 */
if ($add->AddItemToInflowReceipt(new \StructType\AddItemToInflowReceiptRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddShipmentsToBatch operation/method
 */
if ($add->AddShipmentsToBatch(new \StructType\AddShipmentsToBatchRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddPurchaseOrderItems operation/method
 */
if ($add->AddPurchaseOrderItems(new \StructType\AddPurchaseOrderItemsRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddOrEditItemLabels operation/method
 */
if ($add->AddOrEditItemLabels(new \StructType\AddOrEditItemLabelsRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Complete ServiceType
 */
$complete = new \ServiceType\Complete($options);
/**
 * Sample call for CompleteGatePass operation/method
 */
if ($complete->CompleteGatePass(new \StructType\CompleteGatePassRequest()) !== false) {
    print_r($complete->getResult());
} else {
    print_r($complete->getLastError());
}
/**
 * Samples for Accept ServiceType
 */
$accept = new \ServiceType\Accept($options);
/**
 * Sample call for AcceptSaleOrderItemAlternate operation/method
 */
if ($accept->AcceptSaleOrderItemAlternate(new \StructType\AcceptSaleOrderItemAlternateRequest()) !== false) {
    print_r($accept->getResult());
} else {
    print_r($accept->getLastError());
}
/**
 * Samples for Edit ServiceType
 */
$edit = new \ServiceType\Edit($options);
/**
 * Sample call for EditSaleOrderItemMetadata operation/method
 */
if ($edit->EditSaleOrderItemMetadata(new \StructType\EditSaleOrderItemMetadataRequest()) !== false) {
    print_r($edit->getResult());
} else {
    print_r($edit->getLastError());
}
/**
 * Sample call for EditShippingPackage operation/method
 */
if ($edit->EditShippingPackage(new \StructType\EditShippingPackageRequest()) !== false) {
    print_r($edit->getResult());
} else {
    print_r($edit->getLastError());
}
/**
 * Sample call for EditItemType operation/method
 */
if ($edit->EditItemType(new \StructType\ItemTypeRequest()) !== false) {
    print_r($edit->getResult());
} else {
    print_r($edit->getLastError());
}
/**
 * Sample call for EditVendorItemType operation/method
 */
if ($edit->EditVendorItemType(new \StructType\VendorItemType()) !== false) {
    print_r($edit->getResult());
} else {
    print_r($edit->getLastError());
}
/**
 * Sample call for EditSaleOrderMetadata operation/method
 */
if ($edit->EditSaleOrderMetadata(new \StructType\EditSaleOrderMetadataRequest()) !== false) {
    print_r($edit->getResult());
} else {
    print_r($edit->getLastError());
}
/**
 * Sample call for EditVendorDetails operation/method
 */
if ($edit->EditVendorDetails(new \StructType\EditVendorDetailsRequest()) !== false) {
    print_r($edit->getResult());
} else {
    print_r($edit->getLastError());
}
/**
 * Sample call for EditSaleOrderAddress operation/method
 */
if ($edit->EditSaleOrderAddress(new \StructType\EditSaleOrderAddressRequest()) !== false) {
    print_r($edit->getResult());
} else {
    print_r($edit->getLastError());
}
/**
 * Sample call for EditCustomer operation/method
 */
if ($edit->EditCustomer(new \StructType\EditCustomerRequest()) !== false) {
    print_r($edit->getResult());
} else {
    print_r($edit->getLastError());
}
/**
 * Sample call for EditGatePass operation/method
 */
if ($edit->EditGatePass(new \StructType\EditGatePassRequest()) !== false) {
    print_r($edit->getResult());
} else {
    print_r($edit->getLastError());
}
/**
 * Sample call for EditFacility operation/method
 */
if ($edit->EditFacility(new \StructType\EditFacilityRequest()) !== false) {
    print_r($edit->getResult());
} else {
    print_r($edit->getLastError());
}
/**
 * Sample call for EditScriptConfig operation/method
 */
if ($edit->EditScriptConfig(new \StructType\EditScriptConfigRequest()) !== false) {
    print_r($edit->getResult());
} else {
    print_r($edit->getLastError());
}
/**
 * Samples for Split ServiceType
 */
$split = new \ServiceType\Split($options);
/**
 * Sample call for SplitShippingPackage operation/method
 */
if ($split->SplitShippingPackage(new \StructType\SplitShippingPackageRequest()) !== false) {
    print_r($split->getResult());
} else {
    print_r($split->getLastError());
}
/**
 * Samples for Modify ServiceType
 */
$modify = new \ServiceType\Modify($options);
/**
 * Sample call for ModifyPacketSaleOrder operation/method
 */
if ($modify->ModifyPacketSaleOrder(new \StructType\ModifyPacketSaleOrderRequest()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Samples for Dispatch ServiceType
 */
$dispatch = new \ServiceType\Dispatch($options);
/**
 * Sample call for DispatchShippingPackage operation/method
 */
if ($dispatch->DispatchShippingPackage(new \StructType\DispatchShippingPackageRequest()) !== false) {
    print_r($dispatch->getResult());
} else {
    print_r($dispatch->getLastError());
}
/**
 * Samples for Hold ServiceType
 */
$hold = new \ServiceType\Hold($options);
/**
 * Sample call for HoldSaleOrder operation/method
 */
if ($hold->HoldSaleOrder(new \StructType\HoldSaleOrderRequest()) !== false) {
    print_r($hold->getResult());
} else {
    print_r($hold->getLastError());
}
/**
 * Sample call for HoldSaleOrderItems operation/method
 */
if ($hold->HoldSaleOrderItems(new \StructType\HoldSaleOrderItemsRequest()) !== false) {
    print_r($hold->getResult());
} else {
    print_r($hold->getLastError());
}
/**
 * Samples for Close ServiceType
 */
$close = new \ServiceType\Close($options);
/**
 * Sample call for ClosePurchaseOrder operation/method
 */
if ($close->ClosePurchaseOrder(new \StructType\ClosePurchaseOrderRequest()) !== false) {
    print_r($close->getResult());
} else {
    print_r($close->getLastError());
}
/**
 * Samples for Approve ServiceType
 */
$approve = new \ServiceType\Approve($options);
/**
 * Sample call for ApprovePurchaseOrder operation/method
 */
if ($approve->ApprovePurchaseOrder(new \StructType\ApprovePurchaseOrderRequest()) !== false) {
    print_r($approve->getResult());
} else {
    print_r($approve->getLastError());
}
/**
 * Samples for Pick ServiceType
 */
$pick = new \ServiceType\Pick($options);
/**
 * Sample call for PickShippingPackage operation/method
 */
if ($pick->PickShippingPackage(new \StructType\PickShippingPackageRequest()) !== false) {
    print_r($pick->getResult());
} else {
    print_r($pick->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for SetSaleOrderPriority operation/method
 */
if ($set->SetSaleOrderPriority(new \StructType\SetSaleOrderPriorityRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \ServiceType\Search($options);
/**
 * Sample call for SearchItemTypes operation/method
 */
if ($search->SearchItemTypes(new \StructType\SearchItemTypesRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchSaleOrder operation/method
 */
if ($search->SearchSaleOrder(new \StructType\SearchSaleOrderRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Receive ServiceType
 */
$receive = new \ServiceType\Receive($options);
/**
 * Sample call for ReceiveReversePickupFromRetail operation/method
 */
if ($receive->ReceiveReversePickupFromRetail(new \StructType\ReceiveReversePickupFromRetailRequest()) !== false) {
    print_r($receive->getResult());
} else {
    print_r($receive->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for CancelReversePickup operation/method
 */
if ($cancel->CancelReversePickup(new \StructType\CancelReversePickupRequest()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for CancelSaleOrder operation/method
 */
if ($cancel->CancelSaleOrder(new \StructType\CancelSaleOrderRequest()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Verify ServiceType
 */
$verify = new \ServiceType\Verify($options);
/**
 * Sample call for VerifySaleOrder operation/method
 */
if ($verify->VerifySaleOrder(new \StructType\VerifySaleOrderRequest()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for UpdateTrackingStatus operation/method
 */
if ($update->UpdateTrackingStatus(new \StructType\UpdateTrackingStatusRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Auto ServiceType
 */
$auto = new \ServiceType\Auto($options);
/**
 * Sample call for AutoCompletePutaway operation/method
 */
if ($auto->AutoCompletePutaway(new \StructType\AutoCompletePutawayRequest()) !== false) {
    print_r($auto->getResult());
} else {
    print_r($auto->getLastError());
}
/**
 * Samples for Inventory ServiceType
 */
$inventory = new \ServiceType\Inventory($options);
/**
 * Sample call for InventoryAdjustment operation/method
 */
if ($inventory->InventoryAdjustment(new \StructType\InventoryAdjustmentRequest()) !== false) {
    print_r($inventory->getResult());
} else {
    print_r($inventory->getLastError());
}
/**
 * Samples for Unblock ServiceType
 */
$unblock = new \ServiceType\Unblock($options);
/**
 * Sample call for UnblockSaleOrderItemsInventory operation/method
 */
if ($unblock->UnblockSaleOrderItemsInventory(new \StructType\UnblockSaleOrderItemsInventoryRequest()) !== false) {
    print_r($unblock->getResult());
} else {
    print_r($unblock->getLastError());
}
/**
 * Samples for Mark ServiceType
 */
$mark = new \ServiceType\Mark($options);
/**
 * Sample call for MarkItemDamagedOutboundQC operation/method
 */
if ($mark->MarkItemDamagedOutboundQC(new \StructType\MarkItemDamagedOutboundQCRequest()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
