<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WsFacilityItemType StructType
 * @subpackage Structs
 */
class WsFacilityItemType extends AbstractStructBase
{
    /**
     * The FacilityCode
     * @var string
     */
    public $FacilityCode;
    /**
     * The ItemSku
     * @var string
     */
    public $ItemSku;
    /**
     * The FacilitySkuCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FacilitySkuCode;
    /**
     * The Inventory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Inventory;
    /**
     * The TransferPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TransferPrice;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Commission;
    /**
     * The ShippingCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ShippingCharges;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Priority;
    /**
     * The Enabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Enabled;
    /**
     * Constructor method for WsFacilityItemType
     * @uses WsFacilityItemType::setFacilityCode()
     * @uses WsFacilityItemType::setItemSku()
     * @uses WsFacilityItemType::setFacilitySkuCode()
     * @uses WsFacilityItemType::setInventory()
     * @uses WsFacilityItemType::setTransferPrice()
     * @uses WsFacilityItemType::setCommission()
     * @uses WsFacilityItemType::setShippingCharges()
     * @uses WsFacilityItemType::setPriority()
     * @uses WsFacilityItemType::setEnabled()
     * @param string $facilityCode
     * @param string $itemSku
     * @param string $facilitySkuCode
     * @param int $inventory
     * @param float $transferPrice
     * @param float $commission
     * @param float $shippingCharges
     * @param float $priority
     * @param bool $enabled
     */
    public function __construct($facilityCode = null, $itemSku = null, $facilitySkuCode = null, $inventory = null, $transferPrice = null, $commission = null, $shippingCharges = null, $priority = null, $enabled = null)
    {
        $this
            ->setFacilityCode($facilityCode)
            ->setItemSku($itemSku)
            ->setFacilitySkuCode($facilitySkuCode)
            ->setInventory($inventory)
            ->setTransferPrice($transferPrice)
            ->setCommission($commission)
            ->setShippingCharges($shippingCharges)
            ->setPriority($priority)
            ->setEnabled($enabled);
    }
    /**
     * Get FacilityCode value
     * @return string|null
     */
    public function getFacilityCode()
    {
        return $this->FacilityCode;
    }
    /**
     * Set FacilityCode value
     * @param string $facilityCode
     * @return \StructType\WsFacilityItemType
     */
    public function setFacilityCode($facilityCode = null)
    {
        // validation for constraint: string
        if (!is_null($facilityCode) && !is_string($facilityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facilityCode, true), gettype($facilityCode)), __LINE__);
        }
        $this->FacilityCode = $facilityCode;
        return $this;
    }
    /**
     * Get ItemSku value
     * @return string|null
     */
    public function getItemSku()
    {
        return $this->ItemSku;
    }
    /**
     * Set ItemSku value
     * @param string $itemSku
     * @return \StructType\WsFacilityItemType
     */
    public function setItemSku($itemSku = null)
    {
        // validation for constraint: string
        if (!is_null($itemSku) && !is_string($itemSku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemSku, true), gettype($itemSku)), __LINE__);
        }
        $this->ItemSku = $itemSku;
        return $this;
    }
    /**
     * Get FacilitySkuCode value
     * @return string|null
     */
    public function getFacilitySkuCode()
    {
        return $this->FacilitySkuCode;
    }
    /**
     * Set FacilitySkuCode value
     * @param string $facilitySkuCode
     * @return \StructType\WsFacilityItemType
     */
    public function setFacilitySkuCode($facilitySkuCode = null)
    {
        // validation for constraint: string
        if (!is_null($facilitySkuCode) && !is_string($facilitySkuCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facilitySkuCode, true), gettype($facilitySkuCode)), __LINE__);
        }
        $this->FacilitySkuCode = $facilitySkuCode;
        return $this;
    }
    /**
     * Get Inventory value
     * @return int|null
     */
    public function getInventory()
    {
        return $this->Inventory;
    }
    /**
     * Set Inventory value
     * @param int $inventory
     * @return \StructType\WsFacilityItemType
     */
    public function setInventory($inventory = null)
    {
        // validation for constraint: int
        if (!is_null($inventory) && !(is_int($inventory) || ctype_digit($inventory))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inventory, true), gettype($inventory)), __LINE__);
        }
        $this->Inventory = $inventory;
        return $this;
    }
    /**
     * Get TransferPrice value
     * @return float|null
     */
    public function getTransferPrice()
    {
        return $this->TransferPrice;
    }
    /**
     * Set TransferPrice value
     * @param float $transferPrice
     * @return \StructType\WsFacilityItemType
     */
    public function setTransferPrice($transferPrice = null)
    {
        // validation for constraint: float
        if (!is_null($transferPrice) && !(is_float($transferPrice) || is_numeric($transferPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($transferPrice, true), gettype($transferPrice)), __LINE__);
        }
        $this->TransferPrice = $transferPrice;
        return $this;
    }
    /**
     * Get Commission value
     * @return float|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param float $commission
     * @return \StructType\WsFacilityItemType
     */
    public function setCommission($commission = null)
    {
        // validation for constraint: float
        if (!is_null($commission) && !(is_float($commission) || is_numeric($commission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commission, true), gettype($commission)), __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get ShippingCharges value
     * @return float|null
     */
    public function getShippingCharges()
    {
        return $this->ShippingCharges;
    }
    /**
     * Set ShippingCharges value
     * @param float $shippingCharges
     * @return \StructType\WsFacilityItemType
     */
    public function setShippingCharges($shippingCharges = null)
    {
        // validation for constraint: float
        if (!is_null($shippingCharges) && !(is_float($shippingCharges) || is_numeric($shippingCharges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingCharges, true), gettype($shippingCharges)), __LINE__);
        }
        $this->ShippingCharges = $shippingCharges;
        return $this;
    }
    /**
     * Get Priority value
     * @return float|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param float $priority
     * @return \StructType\WsFacilityItemType
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: float
        if (!is_null($priority) && !(is_float($priority) || is_numeric($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get Enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param bool $enabled
     * @return \StructType\WsFacilityItemType
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WsFacilityItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
