<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WsFacilityCreate StructType
 * @subpackage Structs
 */
class WsFacilityCreate extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - default: WAREHOUSE
     * @var string
     */
    public $Type;
    /**
     * The DisplayName
     * @var string
     */
    public $DisplayName;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Enabled
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $Enabled;
    /**
     * The TaxExempted
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $TaxExempted;
    /**
     * The Pan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Pan;
    /**
     * The Tin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Tin;
    /**
     * The CstNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CstNumber;
    /**
     * The StNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StNumber;
    /**
     * The Website
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Website;
    /**
     * The BillingAddress
     * @var \StructType\WsPartyAddress
     */
    public $BillingAddress;
    /**
     * The ShippingAddress
     * @var \StructType\WsPartyAddress
     */
    public $ShippingAddress;
    /**
     * The PartyContacts
     * @var \StructType\PartyContacts
     */
    public $PartyContacts;
    /**
     * Constructor method for WsFacilityCreate
     * @uses WsFacilityCreate::setType()
     * @uses WsFacilityCreate::setDisplayName()
     * @uses WsFacilityCreate::setName()
     * @uses WsFacilityCreate::setCode()
     * @uses WsFacilityCreate::setEnabled()
     * @uses WsFacilityCreate::setTaxExempted()
     * @uses WsFacilityCreate::setPan()
     * @uses WsFacilityCreate::setTin()
     * @uses WsFacilityCreate::setCstNumber()
     * @uses WsFacilityCreate::setStNumber()
     * @uses WsFacilityCreate::setWebsite()
     * @uses WsFacilityCreate::setBillingAddress()
     * @uses WsFacilityCreate::setShippingAddress()
     * @uses WsFacilityCreate::setPartyContacts()
     * @param string $type
     * @param string $displayName
     * @param string $name
     * @param string $code
     * @param bool $enabled
     * @param bool $taxExempted
     * @param string $pan
     * @param string $tin
     * @param string $cstNumber
     * @param string $stNumber
     * @param string $website
     * @param \StructType\WsPartyAddress $billingAddress
     * @param \StructType\WsPartyAddress $shippingAddress
     * @param \StructType\PartyContacts $partyContacts
     */
    public function __construct($type = 'WAREHOUSE', $displayName = null, $name = null, $code = null, $enabled = true, $taxExempted = false, $pan = null, $tin = null, $cstNumber = null, $stNumber = null, $website = null, \StructType\WsPartyAddress $billingAddress = null, \StructType\WsPartyAddress $shippingAddress = null, \StructType\PartyContacts $partyContacts = null)
    {
        $this
            ->setType($type)
            ->setDisplayName($displayName)
            ->setName($name)
            ->setCode($code)
            ->setEnabled($enabled)
            ->setTaxExempted($taxExempted)
            ->setPan($pan)
            ->setTin($tin)
            ->setCstNumber($cstNumber)
            ->setStNumber($stNumber)
            ->setWebsite($website)
            ->setBillingAddress($billingAddress)
            ->setShippingAddress($shippingAddress)
            ->setPartyContacts($partyContacts);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\WsFacilityCreate
     */
    public function setType($type = 'WAREHOUSE')
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\WsFacilityCreate
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\WsFacilityCreate
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\WsFacilityCreate
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param bool $enabled
     * @return \StructType\WsFacilityCreate
     */
    public function setEnabled($enabled = true)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }
    /**
     * Get TaxExempted value
     * @return bool|null
     */
    public function getTaxExempted()
    {
        return $this->TaxExempted;
    }
    /**
     * Set TaxExempted value
     * @param bool $taxExempted
     * @return \StructType\WsFacilityCreate
     */
    public function setTaxExempted($taxExempted = false)
    {
        // validation for constraint: boolean
        if (!is_null($taxExempted) && !is_bool($taxExempted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxExempted, true), gettype($taxExempted)), __LINE__);
        }
        $this->TaxExempted = $taxExempted;
        return $this;
    }
    /**
     * Get Pan value
     * @return string|null
     */
    public function getPan()
    {
        return $this->Pan;
    }
    /**
     * Set Pan value
     * @param string $pan
     * @return \StructType\WsFacilityCreate
     */
    public function setPan($pan = null)
    {
        // validation for constraint: string
        if (!is_null($pan) && !is_string($pan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pan, true), gettype($pan)), __LINE__);
        }
        $this->Pan = $pan;
        return $this;
    }
    /**
     * Get Tin value
     * @return string|null
     */
    public function getTin()
    {
        return $this->Tin;
    }
    /**
     * Set Tin value
     * @param string $tin
     * @return \StructType\WsFacilityCreate
     */
    public function setTin($tin = null)
    {
        // validation for constraint: string
        if (!is_null($tin) && !is_string($tin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tin, true), gettype($tin)), __LINE__);
        }
        $this->Tin = $tin;
        return $this;
    }
    /**
     * Get CstNumber value
     * @return string|null
     */
    public function getCstNumber()
    {
        return $this->CstNumber;
    }
    /**
     * Set CstNumber value
     * @param string $cstNumber
     * @return \StructType\WsFacilityCreate
     */
    public function setCstNumber($cstNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cstNumber) && !is_string($cstNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cstNumber, true), gettype($cstNumber)), __LINE__);
        }
        $this->CstNumber = $cstNumber;
        return $this;
    }
    /**
     * Get StNumber value
     * @return string|null
     */
    public function getStNumber()
    {
        return $this->StNumber;
    }
    /**
     * Set StNumber value
     * @param string $stNumber
     * @return \StructType\WsFacilityCreate
     */
    public function setStNumber($stNumber = null)
    {
        // validation for constraint: string
        if (!is_null($stNumber) && !is_string($stNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stNumber, true), gettype($stNumber)), __LINE__);
        }
        $this->StNumber = $stNumber;
        return $this;
    }
    /**
     * Get Website value
     * @return string|null
     */
    public function getWebsite()
    {
        return $this->Website;
    }
    /**
     * Set Website value
     * @param string $website
     * @return \StructType\WsFacilityCreate
     */
    public function setWebsite($website = null)
    {
        // validation for constraint: string
        if (!is_null($website) && !is_string($website)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($website, true), gettype($website)), __LINE__);
        }
        $this->Website = $website;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return \StructType\WsPartyAddress|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param \StructType\WsPartyAddress $billingAddress
     * @return \StructType\WsFacilityCreate
     */
    public function setBillingAddress(\StructType\WsPartyAddress $billingAddress = null)
    {
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get ShippingAddress value
     * @return \StructType\WsPartyAddress|null
     */
    public function getShippingAddress()
    {
        return $this->ShippingAddress;
    }
    /**
     * Set ShippingAddress value
     * @param \StructType\WsPartyAddress $shippingAddress
     * @return \StructType\WsFacilityCreate
     */
    public function setShippingAddress(\StructType\WsPartyAddress $shippingAddress = null)
    {
        $this->ShippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get PartyContacts value
     * @return \StructType\PartyContacts|null
     */
    public function getPartyContacts()
    {
        return $this->PartyContacts;
    }
    /**
     * Set PartyContacts value
     * @param \StructType\PartyContacts $partyContacts
     * @return \StructType\WsFacilityCreate
     */
    public function setPartyContacts(\StructType\PartyContacts $partyContacts = null)
    {
        $this->PartyContacts = $partyContacts;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WsFacilityCreate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
