<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorItemType StructType
 * @subpackage Structs
 */
class VendorItemType_1 extends AbstractStructBase
{
    /**
     * The VendorCode
     * @var string
     */
    public $VendorCode;
    /**
     * The SellerSkuCode
     * @var string
     */
    public $SellerSkuCode;
    /**
     * The ItemTypeName
     * @var string
     */
    public $ItemTypeName;
    /**
     * The ItemSKU
     * @var string
     */
    public $ItemSKU;
    /**
     * The ImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ImageUrl;
    /**
     * The PageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PageUrl;
    /**
     * The Color
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Color;
    /**
     * The Brand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Brand;
    /**
     * The Size
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Size;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $UnitPrice;
    /**
     * The MaxRetailPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MaxRetailPrice;
    /**
     * The Enabled
     * @var bool
     */
    public $Enabled;
    /**
     * Constructor method for VendorItemType
     * @uses VendorItemType_1::setVendorCode_1()
     * @uses VendorItemType_1::setSellerSkuCode()
     * @uses VendorItemType_1::setItemTypeName()
     * @uses VendorItemType_1::setItemSKU_1()
     * @uses VendorItemType_1::setImageUrl()
     * @uses VendorItemType_1::setPageUrl()
     * @uses VendorItemType_1::setColor()
     * @uses VendorItemType_1::setBrand()
     * @uses VendorItemType_1::setSize()
     * @uses VendorItemType_1::setUnitPrice_1()
     * @uses VendorItemType_1::setMaxRetailPrice()
     * @uses VendorItemType_1::setEnabled_1()
     * @param string $vendorCode
     * @param string $sellerSkuCode
     * @param string $itemTypeName
     * @param string $itemSKU
     * @param string $imageUrl
     * @param string $pageUrl
     * @param string $color
     * @param string $brand
     * @param string $size
     * @param float $unitPrice
     * @param float $maxRetailPrice
     * @param bool $enabled
     */
    public function __construct($vendorCode_1 = null, $sellerSkuCode = null, $itemTypeName = null, $itemSKU_1 = null, $imageUrl = null, $pageUrl = null, $color = null, $brand = null, $size = null, $unitPrice_1 = null, $maxRetailPrice = null, $enabled_1 = null)
    {
        $this
            ->setVendorCode_1($vendorCode_1)
            ->setSellerSkuCode($sellerSkuCode)
            ->setItemTypeName($itemTypeName)
            ->setItemSKU_1($itemSKU_1)
            ->setImageUrl($imageUrl)
            ->setPageUrl($pageUrl)
            ->setColor($color)
            ->setBrand($brand)
            ->setSize($size)
            ->setUnitPrice_1($unitPrice_1)
            ->setMaxRetailPrice($maxRetailPrice)
            ->setEnabled_1($enabled_1);
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode_1()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\VendorItemType_1
     */
    public function setVendorCode_1($vendorCode_1 = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode_1) && !is_string($vendorCode_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCode_1, true), gettype($vendorCode_1)), __LINE__);
        }
        $this->VendorCode = $vendorCode_1;
        return $this;
    }
    /**
     * Get SellerSkuCode value
     * @return string|null
     */
    public function getSellerSkuCode()
    {
        return $this->SellerSkuCode;
    }
    /**
     * Set SellerSkuCode value
     * @param string $sellerSkuCode
     * @return \StructType\VendorItemType_1
     */
    public function setSellerSkuCode($sellerSkuCode = null)
    {
        // validation for constraint: string
        if (!is_null($sellerSkuCode) && !is_string($sellerSkuCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerSkuCode, true), gettype($sellerSkuCode)), __LINE__);
        }
        $this->SellerSkuCode = $sellerSkuCode;
        return $this;
    }
    /**
     * Get ItemTypeName value
     * @return string|null
     */
    public function getItemTypeName()
    {
        return $this->ItemTypeName;
    }
    /**
     * Set ItemTypeName value
     * @param string $itemTypeName
     * @return \StructType\VendorItemType_1
     */
    public function setItemTypeName($itemTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($itemTypeName) && !is_string($itemTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemTypeName, true), gettype($itemTypeName)), __LINE__);
        }
        $this->ItemTypeName = $itemTypeName;
        return $this;
    }
    /**
     * Get ItemSKU value
     * @return string|null
     */
    public function getItemSKU_1()
    {
        return $this->ItemSKU;
    }
    /**
     * Set ItemSKU value
     * @param string $itemSKU
     * @return \StructType\VendorItemType_1
     */
    public function setItemSKU_1($itemSKU_1 = null)
    {
        // validation for constraint: string
        if (!is_null($itemSKU_1) && !is_string($itemSKU_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemSKU_1, true), gettype($itemSKU_1)), __LINE__);
        }
        $this->ItemSKU = $itemSKU_1;
        return $this;
    }
    /**
     * Get ImageUrl value
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->ImageUrl;
    }
    /**
     * Set ImageUrl value
     * @param string $imageUrl
     * @return \StructType\VendorItemType_1
     */
    public function setImageUrl($imageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($imageUrl) && !is_string($imageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageUrl, true), gettype($imageUrl)), __LINE__);
        }
        $this->ImageUrl = $imageUrl;
        return $this;
    }
    /**
     * Get PageUrl value
     * @return string|null
     */
    public function getPageUrl()
    {
        return $this->PageUrl;
    }
    /**
     * Set PageUrl value
     * @param string $pageUrl
     * @return \StructType\VendorItemType_1
     */
    public function setPageUrl($pageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($pageUrl) && !is_string($pageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pageUrl, true), gettype($pageUrl)), __LINE__);
        }
        $this->PageUrl = $pageUrl;
        return $this;
    }
    /**
     * Get Color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->Color;
    }
    /**
     * Set Color value
     * @param string $color
     * @return \StructType\VendorItemType_1
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        $this->Color = $color;
        return $this;
    }
    /**
     * Get Brand value
     * @return string|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @param string $brand
     * @return \StructType\VendorItemType_1
     */
    public function setBrand($brand = null)
    {
        // validation for constraint: string
        if (!is_null($brand) && !is_string($brand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brand, true), gettype($brand)), __LINE__);
        }
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Get Size value
     * @return string|null
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param string $size
     * @return \StructType\VendorItemType_1
     */
    public function setSize($size = null)
    {
        // validation for constraint: string
        if (!is_null($size) && !is_string($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->Size = $size;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return float|null
     */
    public function getUnitPrice_1()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param float $unitPrice
     * @return \StructType\VendorItemType_1
     */
    public function setUnitPrice_1($unitPrice_1 = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice_1) && !(is_float($unitPrice_1) || is_numeric($unitPrice_1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice_1, true), gettype($unitPrice_1)), __LINE__);
        }
        $this->UnitPrice = $unitPrice_1;
        return $this;
    }
    /**
     * Get MaxRetailPrice value
     * @return float|null
     */
    public function getMaxRetailPrice()
    {
        return $this->MaxRetailPrice;
    }
    /**
     * Set MaxRetailPrice value
     * @param float $maxRetailPrice
     * @return \StructType\VendorItemType_1
     */
    public function setMaxRetailPrice($maxRetailPrice = null)
    {
        // validation for constraint: float
        if (!is_null($maxRetailPrice) && !(is_float($maxRetailPrice) || is_numeric($maxRetailPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxRetailPrice, true), gettype($maxRetailPrice)), __LINE__);
        }
        $this->MaxRetailPrice = $maxRetailPrice;
        return $this;
    }
    /**
     * Get Enabled value
     * @return bool|null
     */
    public function getEnabled_1()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param bool $enabled
     * @return \StructType\VendorItemType_1
     */
    public function setEnabled_1($enabled_1 = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled_1) && !is_bool($enabled_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled_1, true), gettype($enabled_1)), __LINE__);
        }
        $this->Enabled = $enabled_1;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VendorItemType_1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
