<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorInvoice StructType
 * @subpackage Structs
 */
class VendorInvoice extends AbstractStructBase
{
    /**
     * The VendorInvoiceNumber
     * @var string
     */
    public $VendorInvoiceNumber;
    /**
     * The VendorInvoiceDate
     * @var string
     */
    public $VendorInvoiceDate;
    /**
     * The PurchaseOrderCode
     * @var string
     */
    public $PurchaseOrderCode;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The CurrencyConversionRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CurrencyConversionRate;
    /**
     * Constructor method for VendorInvoice
     * @uses VendorInvoice::setVendorInvoiceNumber()
     * @uses VendorInvoice::setVendorInvoiceDate()
     * @uses VendorInvoice::setPurchaseOrderCode()
     * @uses VendorInvoice::setCurrencyCode()
     * @uses VendorInvoice::setCurrencyConversionRate()
     * @param string $vendorInvoiceNumber
     * @param string $vendorInvoiceDate
     * @param string $purchaseOrderCode
     * @param string $currencyCode
     * @param float $currencyConversionRate
     */
    public function __construct($vendorInvoiceNumber = null, $vendorInvoiceDate = null, $purchaseOrderCode = null, $currencyCode = null, $currencyConversionRate = null)
    {
        $this
            ->setVendorInvoiceNumber($vendorInvoiceNumber)
            ->setVendorInvoiceDate($vendorInvoiceDate)
            ->setPurchaseOrderCode($purchaseOrderCode)
            ->setCurrencyCode($currencyCode)
            ->setCurrencyConversionRate($currencyConversionRate);
    }
    /**
     * Get VendorInvoiceNumber value
     * @return string|null
     */
    public function getVendorInvoiceNumber()
    {
        return $this->VendorInvoiceNumber;
    }
    /**
     * Set VendorInvoiceNumber value
     * @param string $vendorInvoiceNumber
     * @return \StructType\VendorInvoice
     */
    public function setVendorInvoiceNumber($vendorInvoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vendorInvoiceNumber) && !is_string($vendorInvoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorInvoiceNumber, true), gettype($vendorInvoiceNumber)), __LINE__);
        }
        $this->VendorInvoiceNumber = $vendorInvoiceNumber;
        return $this;
    }
    /**
     * Get VendorInvoiceDate value
     * @return string|null
     */
    public function getVendorInvoiceDate()
    {
        return $this->VendorInvoiceDate;
    }
    /**
     * Set VendorInvoiceDate value
     * @param string $vendorInvoiceDate
     * @return \StructType\VendorInvoice
     */
    public function setVendorInvoiceDate($vendorInvoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($vendorInvoiceDate) && !is_string($vendorInvoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorInvoiceDate, true), gettype($vendorInvoiceDate)), __LINE__);
        }
        $this->VendorInvoiceDate = $vendorInvoiceDate;
        return $this;
    }
    /**
     * Get PurchaseOrderCode value
     * @return string|null
     */
    public function getPurchaseOrderCode()
    {
        return $this->PurchaseOrderCode;
    }
    /**
     * Set PurchaseOrderCode value
     * @param string $purchaseOrderCode
     * @return \StructType\VendorInvoice
     */
    public function setPurchaseOrderCode($purchaseOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderCode) && !is_string($purchaseOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderCode, true), gettype($purchaseOrderCode)), __LINE__);
        }
        $this->PurchaseOrderCode = $purchaseOrderCode;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\VendorInvoice
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get CurrencyConversionRate value
     * @return float|null
     */
    public function getCurrencyConversionRate()
    {
        return $this->CurrencyConversionRate;
    }
    /**
     * Set CurrencyConversionRate value
     * @param float $currencyConversionRate
     * @return \StructType\VendorInvoice
     */
    public function setCurrencyConversionRate($currencyConversionRate = null)
    {
        // validation for constraint: float
        if (!is_null($currencyConversionRate) && !(is_float($currencyConversionRate) || is_numeric($currencyConversionRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currencyConversionRate, true), gettype($currencyConversionRate)), __LINE__);
        }
        $this->CurrencyConversionRate = $currencyConversionRate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VendorInvoice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
