<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SplitShippingPackageRequest StructType
 * @subpackage Structs
 */
class SplitShippingPackageRequest extends AbstractStructBase
{
    /**
     * The ShippingPackageCode
     * @var string
     */
    public $ShippingPackageCode;
    /**
     * The SplitSaleOrderItems
     * @var \StructType\SplitSaleOrderItems
     */
    public $SplitSaleOrderItems;
    /**
     * Constructor method for SplitShippingPackageRequest
     * @uses SplitShippingPackageRequest::setShippingPackageCode()
     * @uses SplitShippingPackageRequest::setSplitSaleOrderItems()
     * @param string $shippingPackageCode
     * @param \StructType\SplitSaleOrderItems $splitSaleOrderItems
     */
    public function __construct($shippingPackageCode = null, \StructType\SplitSaleOrderItems $splitSaleOrderItems = null)
    {
        $this
            ->setShippingPackageCode($shippingPackageCode)
            ->setSplitSaleOrderItems($splitSaleOrderItems);
    }
    /**
     * Get ShippingPackageCode value
     * @return string|null
     */
    public function getShippingPackageCode()
    {
        return $this->ShippingPackageCode;
    }
    /**
     * Set ShippingPackageCode value
     * @param string $shippingPackageCode
     * @return \StructType\SplitShippingPackageRequest
     */
    public function setShippingPackageCode($shippingPackageCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingPackageCode) && !is_string($shippingPackageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingPackageCode, true), gettype($shippingPackageCode)), __LINE__);
        }
        $this->ShippingPackageCode = $shippingPackageCode;
        return $this;
    }
    /**
     * Get SplitSaleOrderItems value
     * @return \StructType\SplitSaleOrderItems|null
     */
    public function getSplitSaleOrderItems()
    {
        return $this->SplitSaleOrderItems;
    }
    /**
     * Set SplitSaleOrderItems value
     * @param \StructType\SplitSaleOrderItems $splitSaleOrderItems
     * @return \StructType\SplitShippingPackageRequest
     */
    public function setSplitSaleOrderItems(\StructType\SplitSaleOrderItems $splitSaleOrderItems = null)
    {
        $this->SplitSaleOrderItems = $splitSaleOrderItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SplitShippingPackageRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
