<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShippingPackage StructType
 * @subpackage Structs
 */
class ShippingPackage extends AbstractStructBase
{
    /**
     * The ShipmentCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentCode;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The ShippingPackageType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShippingPackageType;
    /**
     * The InvoiceCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceCode;
    /**
     * The ShippingProvider
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShippingProvider;
    /**
     * The TrackingNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumber;
    /**
     * The TrackingStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TrackingStatus;
    /**
     * The CourierStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CourierStatus;
    /**
     * The EstimatedWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EstimatedWeight;
    /**
     * The ActualWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ActualWeight;
    /**
     * The DispatchedOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DispatchedOn;
    /**
     * The DeliveredOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveredOn;
    /**
     * The CreatedOn
     * @var string
     */
    public $CreatedOn;
    /**
     * Constructor method for ShippingPackage
     * @uses ShippingPackage::setShipmentCode()
     * @uses ShippingPackage::setStatusCode()
     * @uses ShippingPackage::setShippingPackageType()
     * @uses ShippingPackage::setInvoiceCode()
     * @uses ShippingPackage::setShippingProvider()
     * @uses ShippingPackage::setTrackingNumber()
     * @uses ShippingPackage::setTrackingStatus()
     * @uses ShippingPackage::setCourierStatus()
     * @uses ShippingPackage::setEstimatedWeight()
     * @uses ShippingPackage::setActualWeight()
     * @uses ShippingPackage::setDispatchedOn()
     * @uses ShippingPackage::setDeliveredOn()
     * @uses ShippingPackage::setCreatedOn()
     * @param string $shipmentCode
     * @param string $statusCode
     * @param string $shippingPackageType
     * @param string $invoiceCode
     * @param string $shippingProvider
     * @param string $trackingNumber
     * @param string $trackingStatus
     * @param string $courierStatus
     * @param int $estimatedWeight
     * @param int $actualWeight
     * @param string $dispatchedOn
     * @param string $deliveredOn
     * @param string $createdOn
     */
    public function __construct($shipmentCode = null, $statusCode = null, $shippingPackageType = null, $invoiceCode = null, $shippingProvider = null, $trackingNumber = null, $trackingStatus = null, $courierStatus = null, $estimatedWeight = null, $actualWeight = null, $dispatchedOn = null, $deliveredOn = null, $createdOn = null)
    {
        $this
            ->setShipmentCode($shipmentCode)
            ->setStatusCode($statusCode)
            ->setShippingPackageType($shippingPackageType)
            ->setInvoiceCode($invoiceCode)
            ->setShippingProvider($shippingProvider)
            ->setTrackingNumber($trackingNumber)
            ->setTrackingStatus($trackingStatus)
            ->setCourierStatus($courierStatus)
            ->setEstimatedWeight($estimatedWeight)
            ->setActualWeight($actualWeight)
            ->setDispatchedOn($dispatchedOn)
            ->setDeliveredOn($deliveredOn)
            ->setCreatedOn($createdOn);
    }
    /**
     * Get ShipmentCode value
     * @return string|null
     */
    public function getShipmentCode()
    {
        return $this->ShipmentCode;
    }
    /**
     * Set ShipmentCode value
     * @param string $shipmentCode
     * @return \StructType\ShippingPackage
     */
    public function setShipmentCode($shipmentCode = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentCode) && !is_string($shipmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentCode, true), gettype($shipmentCode)), __LINE__);
        }
        $this->ShipmentCode = $shipmentCode;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\ShippingPackage
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get ShippingPackageType value
     * @return string|null
     */
    public function getShippingPackageType()
    {
        return $this->ShippingPackageType;
    }
    /**
     * Set ShippingPackageType value
     * @param string $shippingPackageType
     * @return \StructType\ShippingPackage
     */
    public function setShippingPackageType($shippingPackageType = null)
    {
        // validation for constraint: string
        if (!is_null($shippingPackageType) && !is_string($shippingPackageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingPackageType, true), gettype($shippingPackageType)), __LINE__);
        }
        $this->ShippingPackageType = $shippingPackageType;
        return $this;
    }
    /**
     * Get InvoiceCode value
     * @return string|null
     */
    public function getInvoiceCode()
    {
        return $this->InvoiceCode;
    }
    /**
     * Set InvoiceCode value
     * @param string $invoiceCode
     * @return \StructType\ShippingPackage
     */
    public function setInvoiceCode($invoiceCode = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceCode) && !is_string($invoiceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceCode, true), gettype($invoiceCode)), __LINE__);
        }
        $this->InvoiceCode = $invoiceCode;
        return $this;
    }
    /**
     * Get ShippingProvider value
     * @return string|null
     */
    public function getShippingProvider()
    {
        return $this->ShippingProvider;
    }
    /**
     * Set ShippingProvider value
     * @param string $shippingProvider
     * @return \StructType\ShippingPackage
     */
    public function setShippingProvider($shippingProvider = null)
    {
        // validation for constraint: string
        if (!is_null($shippingProvider) && !is_string($shippingProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingProvider, true), gettype($shippingProvider)), __LINE__);
        }
        $this->ShippingProvider = $shippingProvider;
        return $this;
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \StructType\ShippingPackage
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get TrackingStatus value
     * @return string|null
     */
    public function getTrackingStatus()
    {
        return $this->TrackingStatus;
    }
    /**
     * Set TrackingStatus value
     * @param string $trackingStatus
     * @return \StructType\ShippingPackage
     */
    public function setTrackingStatus($trackingStatus = null)
    {
        // validation for constraint: string
        if (!is_null($trackingStatus) && !is_string($trackingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingStatus, true), gettype($trackingStatus)), __LINE__);
        }
        $this->TrackingStatus = $trackingStatus;
        return $this;
    }
    /**
     * Get CourierStatus value
     * @return string|null
     */
    public function getCourierStatus()
    {
        return $this->CourierStatus;
    }
    /**
     * Set CourierStatus value
     * @param string $courierStatus
     * @return \StructType\ShippingPackage
     */
    public function setCourierStatus($courierStatus = null)
    {
        // validation for constraint: string
        if (!is_null($courierStatus) && !is_string($courierStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($courierStatus, true), gettype($courierStatus)), __LINE__);
        }
        $this->CourierStatus = $courierStatus;
        return $this;
    }
    /**
     * Get EstimatedWeight value
     * @return int|null
     */
    public function getEstimatedWeight()
    {
        return $this->EstimatedWeight;
    }
    /**
     * Set EstimatedWeight value
     * @param int $estimatedWeight
     * @return \StructType\ShippingPackage
     */
    public function setEstimatedWeight($estimatedWeight = null)
    {
        // validation for constraint: int
        if (!is_null($estimatedWeight) && !(is_int($estimatedWeight) || ctype_digit($estimatedWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($estimatedWeight, true), gettype($estimatedWeight)), __LINE__);
        }
        $this->EstimatedWeight = $estimatedWeight;
        return $this;
    }
    /**
     * Get ActualWeight value
     * @return int|null
     */
    public function getActualWeight()
    {
        return $this->ActualWeight;
    }
    /**
     * Set ActualWeight value
     * @param int $actualWeight
     * @return \StructType\ShippingPackage
     */
    public function setActualWeight($actualWeight = null)
    {
        // validation for constraint: int
        if (!is_null($actualWeight) && !(is_int($actualWeight) || ctype_digit($actualWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($actualWeight, true), gettype($actualWeight)), __LINE__);
        }
        $this->ActualWeight = $actualWeight;
        return $this;
    }
    /**
     * Get DispatchedOn value
     * @return string|null
     */
    public function getDispatchedOn()
    {
        return $this->DispatchedOn;
    }
    /**
     * Set DispatchedOn value
     * @param string $dispatchedOn
     * @return \StructType\ShippingPackage
     */
    public function setDispatchedOn($dispatchedOn = null)
    {
        // validation for constraint: string
        if (!is_null($dispatchedOn) && !is_string($dispatchedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dispatchedOn, true), gettype($dispatchedOn)), __LINE__);
        }
        $this->DispatchedOn = $dispatchedOn;
        return $this;
    }
    /**
     * Get DeliveredOn value
     * @return string|null
     */
    public function getDeliveredOn()
    {
        return $this->DeliveredOn;
    }
    /**
     * Set DeliveredOn value
     * @param string $deliveredOn
     * @return \StructType\ShippingPackage
     */
    public function setDeliveredOn($deliveredOn = null)
    {
        // validation for constraint: string
        if (!is_null($deliveredOn) && !is_string($deliveredOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveredOn, true), gettype($deliveredOn)), __LINE__);
        }
        $this->DeliveredOn = $deliveredOn;
        return $this;
    }
    /**
     * Get CreatedOn value
     * @return string|null
     */
    public function getCreatedOn()
    {
        return $this->CreatedOn;
    }
    /**
     * Set CreatedOn value
     * @param string $createdOn
     * @return \StructType\ShippingPackage
     */
    public function setCreatedOn($createdOn = null)
    {
        // validation for constraint: string
        if (!is_null($createdOn) && !is_string($createdOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdOn, true), gettype($createdOn)), __LINE__);
        }
        $this->CreatedOn = $createdOn;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShippingPackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
