<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectedValues StructType
 * @subpackage Structs
 */
class SelectedValues extends AbstractStructBase
{
    /**
     * The SelectedValue
     * @var string
     */
    public $SelectedValue;
    /**
     * Constructor method for SelectedValues
     * @uses SelectedValues::setSelectedValue()
     * @param string $selectedValue
     */
    public function __construct($selectedValue = null)
    {
        $this
            ->setSelectedValue($selectedValue);
    }
    /**
     * Get SelectedValue value
     * @return string|null
     */
    public function getSelectedValue()
    {
        return $this->SelectedValue;
    }
    /**
     * Set SelectedValue value
     * @param string $selectedValue
     * @return \StructType\SelectedValues
     */
    public function setSelectedValue($selectedValue = null)
    {
        // validation for constraint: string
        if (!is_null($selectedValue) && !is_string($selectedValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedValue, true), gettype($selectedValue)), __LINE__);
        }
        $this->SelectedValue = $selectedValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SelectedValues
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
